/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.NoOpSigner;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.internal.config.SignerConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SignerFactory {
    private static final String QUERY_STRING_SIGNER = "QueryStringSignerType";
    private static final String VERSION_THREE_SIGNER = "AWS3SignerType";
    private static final String VERSION_FOUR_SIGNER = "AWS4SignerType";
    private static final String NO_OP_SIGNER = "NoOpSignerType";
    private static final Map<String, Class<? extends Signer>> SIGNERS = new ConcurrentHashMap<String, Class<? extends Signer>>();

    private SignerFactory() {
    }

    public static void registerSigner(String string, Class<? extends Signer> clazz) {
        if (string == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(string, clazz);
    }

    public static Signer getSigner(String string, String string2) {
        return SignerFactory.lookupAndCreateSigner(string, string2);
    }

    public static Signer getSignerByTypeAndService(String string, String string2) {
        return SignerFactory.createSigner(string, string2);
    }

    private static Signer lookupAndCreateSigner(String string, String string2) {
        InternalConfig internalConfig = InternalConfig.Factory.getInternalConfig();
        SignerConfig signerConfig = internalConfig.getSignerConfig(string, string2);
        String string3 = signerConfig.getSignerType();
        return SignerFactory.createSigner(string3, string);
    }

    private static Signer createSigner(String string, String string2) {
        Signer signer;
        Class<? extends Signer> clazz = SIGNERS.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        try {
            signer = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Cannot create an instance of " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Cannot create an instance of " + clazz.getName(), illegalAccessException);
        }
        if (signer instanceof ServiceAwareSigner) {
            ((ServiceAwareSigner)signer).setServiceName(string2);
        }
        return signer;
    }

    static {
        SIGNERS.put(QUERY_STRING_SIGNER, QueryStringSigner.class);
        SIGNERS.put(VERSION_THREE_SIGNER, AWS3Signer.class);
        SIGNERS.put(VERSION_FOUR_SIGNER, AWS4Signer.class);
        SIGNERS.put(NO_OP_SIGNER, NoOpSigner.class);
    }
}

