/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.util.LinkedList;
import java.util.List;

public class AWSCredentialsProviderChain
implements AWSCredentialsProvider {
    private static final Log log = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private List<AWSCredentialsProvider> credentialsProviders = new LinkedList<AWSCredentialsProvider>();
    private boolean reuseLastProvider = true;
    private AWSCredentialsProvider lastUsedProvider;

    public AWSCredentialsProviderChain(AWSCredentialsProvider ... aWSCredentialsProviderArray) {
        if (aWSCredentialsProviderArray == null || aWSCredentialsProviderArray.length == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        for (AWSCredentialsProvider aWSCredentialsProvider : aWSCredentialsProviderArray) {
            this.credentialsProviders.add(aWSCredentialsProvider);
        }
    }

    public boolean getReuseLastProvider() {
        return this.reuseLastProvider;
    }

    public void setReuseLastProvider(boolean bl) {
        this.reuseLastProvider = bl;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.reuseLastProvider && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        for (AWSCredentialsProvider aWSCredentialsProvider : this.credentialsProviders) {
            try {
                AWSCredentials aWSCredentials = aWSCredentialsProvider.getCredentials();
                if (aWSCredentials.getAWSAccessKeyId() == null || aWSCredentials.getAWSSecretKey() == null) continue;
                log.debug("Loading credentials from " + aWSCredentialsProvider.toString());
                this.lastUsedProvider = aWSCredentialsProvider;
                return aWSCredentials;
            }
            catch (Exception exception) {
                log.debug("Unable to load credentials from " + aWSCredentialsProvider.toString() + ": " + exception.getMessage());
            }
        }
        throw new AmazonClientException("Unable to load AWS credentials from any provider in the chain");
    }

    @Override
    public void refresh() {
        for (AWSCredentialsProvider aWSCredentialsProvider : this.credentialsProviders) {
            aWSCredentialsProvider.refresh();
        }
    }
}

