/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.IdentityChangedListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AWSAbstractCognitoIdentityProvider
implements AWSCognitoIdentityProvider {
    private String identityId;
    private final String accountId;
    private final String identityPoolId;
    private String token;
    protected Set<IdentityChangedListener> listeners;
    protected Map<String, String> loginsMap;

    public AWSAbstractCognitoIdentityProvider(String string, String string2) {
        this.accountId = string;
        this.identityPoolId = string2;
        this.loginsMap = new HashMap<String, String>();
        this.listeners = new HashSet<IdentityChangedListener>();
    }

    public abstract String getProviderName();

    @Override
    public String getIdentityId() {
        return this.identityId;
    }

    protected void setIdentityId(String string) {
        this.identityId = string;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    protected void setToken(String string) {
        this.token = string;
    }

    @Override
    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public Map<String, String> getLogins() {
        return this.loginsMap;
    }

    @Override
    public void setLogins(Map<String, String> map) {
        this.loginsMap = map;
    }

    @Override
    public void unregisterIdentityChangedListener(IdentityChangedListener identityChangedListener) {
        this.listeners.remove(identityChangedListener);
    }

    @Override
    public void registerIdentityChangedListener(IdentityChangedListener identityChangedListener) {
        this.listeners.add(identityChangedListener);
    }

    @Override
    public void identityChanged(String string) {
        String string2 = this.identityId;
        this.identityId = string;
        for (IdentityChangedListener identityChangedListener : this.listeners) {
            identityChangedListener.identityChanged(string2, this.identityId);
        }
    }

    protected void appendUserAgent(AmazonWebServiceRequest amazonWebServiceRequest, String string) {
        amazonWebServiceRequest.getRequestClientOptions().appendUserAgent(string);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    protected String getUserAgent() {
        return "";
    }

    protected void update(String string, String string2) {
        if (this.identityId == null || !this.identityId.equals(string)) {
            this.identityChanged(string);
        }
        if (this.token == null || !this.token.equals(string2)) {
            this.token = string2;
        }
    }
}

