/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream.xerces.util;

import com.amazonaws.javax.xml.stream.XMLBufferListener;
import com.amazonaws.javax.xml.stream.xerces.xni.Augmentations;
import com.amazonaws.javax.xml.stream.xerces.xni.QName;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLAttributes;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLString;

public class XMLAttributesImpl
implements XMLBufferListener,
XMLAttributes {
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int tableSize) {
        this.fTableViewBuckets = tableSize;
        for (int i = 0; i < this.fAttributes.length; ++i) {
            this.fAttributes[i] = new Attribute();
        }
    }

    public int addAttribute(QName name, String type, String value) {
        return this.addAttribute(name, type, value, null);
    }

    public int addAttribute(QName name, String type, String value, XMLString valueCache) {
        int index;
        if (this.fLength < 20) {
            int n = index = name.uri != null && !name.uri.equals("") ? this.getIndexFast(name.uri, name.localpart) : this.getIndexFast(name.rawname);
            if (index == -1) {
                index = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributes = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                        attributes[i] = new Attribute();
                    }
                    this.fAttributes = attributes;
                }
            }
        } else if (name.uri == null || name.uri.length() == 0 || (index = this.getIndexFast(name.uri, name.localpart)) == -1) {
            int bucket;
            if (!this.fIsTableViewConsistent || this.fLength == 20) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[bucket = this.getTableViewBucket(name.rawname)] != this.fLargeCount) {
                index = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributes = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                        attributes[i] = new Attribute();
                    }
                    this.fAttributes = attributes;
                }
                this.fAttributeTableViewChainState[bucket] = this.fLargeCount;
                this.fAttributes[index].next = null;
                this.fAttributeTableView[bucket] = this.fAttributes[index];
            } else {
                Attribute found = this.fAttributeTableView[bucket];
                while (found != null && found.name.rawname != name.rawname) {
                    found = found.next;
                }
                if (found == null) {
                    index = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributes = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                        for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                            attributes[i] = new Attribute();
                        }
                        this.fAttributes = attributes;
                    }
                    this.fAttributes[index].next = this.fAttributeTableView[bucket];
                    this.fAttributeTableView[bucket] = this.fAttributes[index];
                } else {
                    index = this.getIndexFast(name.rawname);
                }
            }
        }
        Attribute attribute = this.fAttributes[index];
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.xmlValue = valueCache;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        if (attribute.augs != null) {
            attribute.augs.removeAllItems();
        }
        return index;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int attrIndex) {
        this.fIsTableViewConsistent = false;
        if (attrIndex < this.fLength - 1) {
            Attribute removedAttr = this.fAttributes[attrIndex];
            System.arraycopy(this.fAttributes, attrIndex + 1, this.fAttributes, attrIndex, this.fLength - attrIndex - 1);
            this.fAttributes[this.fLength - 1] = removedAttr;
        }
        --this.fLength;
    }

    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.fAttributes[attrIndex].name);
    }

    public void setType(int attrIndex, String attrType) {
        this.fAttributes[attrIndex].type = attrType;
    }

    public void setValue(int attrIndex, String attrValue) {
        this.setValue(attrIndex, attrValue, null);
    }

    public void setValue(int attrIndex, String attrValue, XMLString value) {
        Attribute attribute = this.fAttributes[attrIndex];
        attribute.value = attrValue;
        attribute.nonNormalizedValue = attrValue;
        attribute.xmlValue = value;
    }

    public void setSpecified(int attrIndex, boolean specified) {
        this.fAttributes[attrIndex].specified = specified;
    }

    public boolean isSpecified(int attrIndex) {
        return this.fAttributes[attrIndex].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[index].type);
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        if (this.fAttributes[index].value == null && this.fAttributes[index].xmlValue != null) {
            this.fAttributes[index].value = this.fAttributes[index].xmlValue.toString();
        }
        return this.fAttributes[index].value;
    }

    public String getQName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String rawname = this.fAttributes[index].name.rawname;
        return rawname != null ? rawname : "";
    }

    public QName getQualifiedName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].name;
    }

    public void setURI(int attrIndex, String uri) {
        this.fAttributes[attrIndex].name.uri = uri;
    }

    public int getIndexFast(String qName) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.rawname != qName) continue;
            return i;
        }
        return -1;
    }

    public void addAttributeNS(QName name, String type, String value) {
        int index = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            Attribute[] attributes = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
            for (int i = this.fAttributes.length; i < attributes.length; ++i) {
                attributes[i] = new Attribute();
            }
            this.fAttributes = attributes;
        }
        Attribute attribute = this.fAttributes[index];
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        if (attribute.augs != null) {
            attribute.augs.removeAllItems();
        }
    }

    public QName checkDuplicatesNS() {
        if (this.fLength <= 20) {
            for (int i = 0; i < this.fLength - 1; ++i) {
                Attribute att1 = this.fAttributes[i];
                for (int j = i + 1; j < this.fLength; ++j) {
                    Attribute att2 = this.fAttributes[j];
                    if (att1.name.localpart != att2.name.localpart || att1.name.uri != att2.name.uri) continue;
                    return att2.name;
                }
            }
        } else {
            this.fIsTableViewConsistent = false;
            this.prepareTableView();
            for (int i = this.fLength - 1; i >= 0; --i) {
                Attribute attr = this.fAttributes[i];
                int bucket = this.getTableViewBucket(attr.name.localpart, attr.name.uri);
                if (this.fAttributeTableViewChainState[bucket] != this.fLargeCount) {
                    this.fAttributeTableViewChainState[bucket] = this.fLargeCount;
                    attr.next = null;
                    this.fAttributeTableView[bucket] = attr;
                    continue;
                }
                Attribute found = this.fAttributeTableView[bucket];
                while (found != null) {
                    if (found.name.localpart == attr.name.localpart && found.name.uri == attr.name.uri) {
                        return attr.name;
                    }
                    found = found.next;
                }
                attr.next = this.fAttributeTableView[bucket];
                this.fAttributeTableView[bucket] = attr;
            }
        }
        return null;
    }

    public int getIndexFast(String uri, String localPart) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart != localPart || attribute.name.uri != uri) continue;
            return i;
        }
        return -1;
    }

    protected String getReportableType(String type) {
        if (type.indexOf(40) == 0 && type.lastIndexOf(41) == type.length() - 1) {
            return "NMTOKEN";
        }
        return type;
    }

    protected int getTableViewBucket(String qname) {
        return (qname.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String localpart, String uri) {
        if (uri == null) {
            return (localpart.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (localpart.hashCode() + uri.hashCode() & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                for (int i = this.fTableViewBuckets - 1; i >= 0; --i) {
                    this.fAttributeTableViewChainState[i] = 0;
                }
            }
            this.fLargeCount = 1;
        }
    }

    protected void prepareTableView() {
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareTableView();
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attr = this.fAttributes[i];
            int bucket = this.getTableViewBucket(attr.name.rawname);
            if (this.fAttributeTableViewChainState[bucket] != this.fLargeCount) {
                this.fAttributeTableViewChainState[bucket] = this.fLargeCount;
                attr.next = null;
                this.fAttributeTableView[bucket] = attr;
                continue;
            }
            attr.next = this.fAttributeTableView[bucket];
            this.fAttributeTableView[bucket] = attr;
        }
    }

    public void refresh() {
        if (this.fLength > 0) {
            for (int i = 0; i < this.fLength; ++i) {
                this.getValue(i);
            }
        }
    }

    public void refresh(int pos) {
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public XMLString xmlValue;
        public String nonNormalizedValue;
        public boolean specified;
        public Augmentations augs = null;
        public Attribute next;

        Attribute() {
        }
    }
}

