/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.com.fasterxml.jackson.core.JsonFactory;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidJsonUnmarshaller;
import com.amazonaws.util.CRC32ChecksumCalculatingInputStream;
import java.io.IOException;
import java.util.Map;

public class JsonResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("com.amazonaws.request");
    private static JsonFactory jsonFactory = new JsonFactory();
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        this.responseUnmarshaller = unmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        log.trace("Parsing service response JSON");
        String string = httpResponse.getHeaders().get("x-amz-crc32");
        CRC32ChecksumCalculatingInputStream cRC32ChecksumCalculatingInputStream = null;
        JsonParser jsonParser = null;
        if (!this.needsConnectionLeftOpen) {
            if (string != null) {
                cRC32ChecksumCalculatingInputStream = new CRC32ChecksumCalculatingInputStream(httpResponse.getContent());
                jsonParser = jsonFactory.createParser(cRC32ChecksumCalculatingInputStream);
            } else {
                jsonParser = jsonFactory.createParser(httpResponse.getContent());
            }
        }
        try {
            AmazonWebServiceResponse<T> amazonWebServiceResponse = new AmazonWebServiceResponse<T>();
            JsonUnmarshallerContext jsonUnmarshallerContext = new JsonUnmarshallerContext(jsonParser, httpResponse);
            this.registerAdditionalMetadataExpressions(jsonUnmarshallerContext);
            T t = this.responseUnmarshaller.unmarshall(jsonUnmarshallerContext);
            if (string != null) {
                long l = Long.parseLong(string);
                long l2 = cRC32ChecksumCalculatingInputStream.getCRC32Checksum();
                if (l2 != l) {
                    throw new CRC32MismatchException("Client calculated crc32 checksum didn't match that calculated by server side");
                }
            }
            amazonWebServiceResponse.setResult(t);
            Map<String, String> map = jsonUnmarshallerContext.getMetadata();
            map.put("AWS_REQUEST_ID", httpResponse.getHeaders().get("x-amzn-RequestId"));
            amazonWebServiceResponse.setResponseMetadata(new ResponseMetadata(map));
            log.trace("Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse2 = amazonWebServiceResponse;
            return amazonWebServiceResponse2;
        }
        finally {
            if (!this.needsConnectionLeftOpen) {
                try {
                    jsonParser.close();
                }
                catch (IOException iOException) {
                    log.warn("Error closing json parser", iOException);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext jsonUnmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }
}

