/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ConnectionManagerFactory;
import com.amazonaws.http.impl.client.HttpRequestNoRetryHandler;
import com.amazonaws.http.impl.client.SdkHttpClient;
import com.amazonaws.org.apache.http.Header;
import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.HttpRequest;
import com.amazonaws.org.apache.http.HttpRequestInterceptor;
import com.amazonaws.org.apache.http.HttpResponse;
import com.amazonaws.org.apache.http.ProtocolException;
import com.amazonaws.org.apache.http.auth.AuthScope;
import com.amazonaws.org.apache.http.auth.ChallengeState;
import com.amazonaws.org.apache.http.auth.NTCredentials;
import com.amazonaws.org.apache.http.client.AuthCache;
import com.amazonaws.org.apache.http.client.HttpClient;
import com.amazonaws.org.apache.http.conn.ConnectTimeoutException;
import com.amazonaws.org.apache.http.conn.params.ConnRouteParams;
import com.amazonaws.org.apache.http.conn.scheme.PlainSocketFactory;
import com.amazonaws.org.apache.http.conn.scheme.Scheme;
import com.amazonaws.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import com.amazonaws.org.apache.http.conn.scheme.SchemeRegistry;
import com.amazonaws.org.apache.http.conn.scheme.SchemeSocketFactory;
import com.amazonaws.org.apache.http.conn.ssl.SSLSocketFactory;
import com.amazonaws.org.apache.http.impl.auth.BasicScheme;
import com.amazonaws.org.apache.http.impl.client.BasicAuthCache;
import com.amazonaws.org.apache.http.impl.client.DefaultRedirectStrategy;
import com.amazonaws.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.amazonaws.org.apache.http.params.BasicHttpParams;
import com.amazonaws.org.apache.http.params.HttpConnectionParams;
import com.amazonaws.org.apache.http.params.HttpParams;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration clientConfiguration) {
        Object object;
        Object object2;
        Object object3;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, clientConfiguration.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(basicHttpParams, clientConfiguration.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled(basicHttpParams, true);
        HttpConnectionParams.setTcpNoDelay(basicHttpParams, true);
        int n = clientConfiguration.getSocketBufferSizeHints()[0];
        int n2 = clientConfiguration.getSocketBufferSizeHints()[1];
        if (n > 0 || n2 > 0) {
            HttpConnectionParams.setSocketBufferSize(basicHttpParams, Math.max(n, n2));
        }
        PoolingClientConnectionManager poolingClientConnectionManager = ConnectionManagerFactory.createPoolingClientConnManager(clientConfiguration, basicHttpParams);
        SdkHttpClient sdkHttpClient = new SdkHttpClient(poolingClientConnectionManager, basicHttpParams);
        sdkHttpClient.setHttpRequestRetryHandler(HttpRequestNoRetryHandler.Singleton);
        sdkHttpClient.setRedirectStrategy(new LocationHeaderNotRequiredRedirectStrategy());
        if (clientConfiguration.getLocalAddress() != null) {
            ConnRouteParams.setLocalAddress(basicHttpParams, clientConfiguration.getLocalAddress());
        }
        try {
            object3 = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());
            SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            object2 = new Scheme("https", 443, sSLSocketFactory);
            object = poolingClientConnectionManager.getSchemeRegistry();
            ((SchemeRegistry)object).register((Scheme)object3);
            ((SchemeRegistry)object).register((Scheme)object2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AmazonClientException("Unable to access default SSL context", noSuchAlgorithmException);
        }
        if (System.getProperty("com.amazonaws.sdk.disableCertChecking") != null) {
            object3 = new Scheme("https", 443, new TrustingSocketFactory());
            sdkHttpClient.getConnectionManager().getSchemeRegistry().register((Scheme)object3);
        }
        object3 = clientConfiguration.getProxyHost();
        int n3 = clientConfiguration.getProxyPort();
        if (object3 != null && n3 > 0) {
            AmazonHttpClient.log.info("Configuring Proxy. Proxy Host: " + (String)object3 + " " + "Proxy Port: " + n3);
            object2 = new HttpHost((String)object3, n3);
            sdkHttpClient.getParams().setParameter("http.route.default-proxy", object2);
            object = clientConfiguration.getProxyUsername();
            String string = clientConfiguration.getProxyPassword();
            String string2 = clientConfiguration.getProxyDomain();
            String string3 = clientConfiguration.getProxyWorkstation();
            if (object != null && string != null) {
                sdkHttpClient.getCredentialsProvider().setCredentials(new AuthScope((String)object3, n3), new NTCredentials((String)object, string, string3, string2));
            }
            if (clientConfiguration.isPreemptiveBasicProxyAuth()) {
                sdkHttpClient.addRequestInterceptor(new PreemptiveProxyAuth((HttpHost)object2), 0);
            }
        }
        return sdkHttpClient;
    }

    private static class PreemptiveProxyAuth
    implements HttpRequestInterceptor {
        private final HttpHost proxyHost;

        public PreemptiveProxyAuth(HttpHost httpHost) {
            this.proxyHost = httpHost;
        }

        @Override
        public void process(HttpRequest httpRequest, HttpContext httpContext) {
            BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
            if (httpContext.getAttribute("http.auth.auth-cache") == null) {
                BasicAuthCache basicAuthCache = new BasicAuthCache();
                basicAuthCache.put(this.proxyHost, basicScheme);
                httpContext.setAttribute("http.auth.auth-cache", basicAuthCache);
            } else {
                AuthCache authCache = (AuthCache)httpContext.getAttribute("http.auth.auth-cache");
                authCache.put(this.proxyHost, basicScheme);
            }
        }
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements SchemeLayeredSocketFactory,
    SchemeSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return sSLContext;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage(), exception);
            }
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }

        @Override
        public Socket createSocket(HttpParams httpParams) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(Socket socket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
            int n = HttpConnectionParams.getConnectionTimeout(httpParams);
            int n2 = HttpConnectionParams.getSoTimeout(httpParams);
            SSLSocket sSLSocket = (SSLSocket)(socket != null ? socket : this.createSocket(httpParams));
            if (inetSocketAddress2 != null) {
                sSLSocket.bind(inetSocketAddress2);
            }
            sSLSocket.connect(inetSocketAddress, n);
            sSLSocket.setSoTimeout(n2);
            return sSLSocket;
        }

        @Override
        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return true;
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String string, int n, HttpParams httpParams) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, true);
        }
    }

    private static final class LocationHeaderNotRequiredRedirectStrategy
    extends DefaultRedirectStrategy {
        private LocationHeaderNotRequiredRedirectStrategy() {
        }

        @Override
        public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
            int n = httpResponse.getStatusLine().getStatusCode();
            Header header = httpResponse.getFirstHeader("location");
            if (header == null && n == 301) {
                return false;
            }
            return super.isRedirected(httpRequest, httpResponse, httpContext);
        }
    }
}

