/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.introspect;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonInclude;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeBindings;
import com.amazonaws.com.fasterxml.jackson.databind.util.Annotations;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected TypeBindings _bindings;
    protected final List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;
    protected AnnotatedMethod _anySetterMethod;
    protected Map<Object, AnnotatedMember> _injectables;
    protected Set<String> _ignoredPropertyNames;
    protected AnnotatedMethod _jsonValueMethod;
    protected AnnotatedMember _anyGetter;

    protected BasicBeanDescription(MapperConfig<?> config, JavaType type, AnnotatedClass classDef, List<BeanPropertyDefinition> props) {
        super(type);
        this._config = config;
        this._annotationIntrospector = config == null ? null : config.getAnnotationIntrospector();
        this._classInfo = classDef;
        this._properties = props;
    }

    protected BasicBeanDescription(POJOPropertiesCollector coll) {
        this(coll.getConfig(), coll.getType(), coll.getClassDef(), coll.getProperties());
        this._objectIdInfo = coll.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector coll) {
        BasicBeanDescription desc = new BasicBeanDescription(coll);
        desc._anySetterMethod = coll.getAnySetterMethod();
        desc._ignoredPropertyNames = coll.getIgnoredPropertyNames();
        desc._injectables = coll.getInjectables();
        desc._jsonValueMethod = coll.getJsonValueMethod();
        return desc;
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector coll) {
        BasicBeanDescription desc = new BasicBeanDescription(coll);
        desc._jsonValueMethod = coll.getJsonValueMethod();
        desc._anyGetter = coll.getAnyGetter();
        return desc;
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> config, JavaType type, AnnotatedClass ac) {
        return new BasicBeanDescription(config, type, ac, Collections.<BeanPropertyDefinition>emptyList());
    }

    public boolean removeProperty(String propName) {
        Iterator<BeanPropertyDefinition> it = this._properties.iterator();
        while (it.hasNext()) {
            BeanPropertyDefinition prop = it.next();
            if (!prop.getName().equals(propName)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties;
    }

    @Override
    public AnnotatedMethod findJsonValueMethod() {
        return this._jsonValueMethod;
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        if (this._ignoredPropertyNames == null) {
            return Collections.emptySet();
        }
        return this._ignoredPropertyNames;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    public TypeBindings bindingsForBeanType() {
        if (this._bindings == null) {
            this._bindings = new TypeBindings(this._config.getTypeFactory(), this._type);
        }
        return this._bindings;
    }

    @Override
    public JavaType resolveType(Type jdkType) {
        if (jdkType == null) {
            return null;
        }
        return this.bindingsForBeanType().resolveType(jdkType);
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        Class<?> clazz;
        if (this._anySetterMethod != null && (clazz = this._anySetterMethod.getRawParameterType(0)) != String.class && clazz != Object.class) {
            throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + this._anySetterMethod.getName() + "(): first argument not of type String or Object, but " + clazz.getName());
        }
        return this._anySetterMethod;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        return this._injectables;
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public Object instantiateBean(boolean bl) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl) {
            annotatedConstructor.fixAccess();
        }
        try {
            return ((Constructor)annotatedConstructor.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + throwable.getMessage(), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._classInfo.findMethod(name, paramTypes);
    }

    @Override
    public JsonFormat.Value findExpectedFormat(JsonFormat.Value defValue) {
        JsonFormat.Value v;
        if (this._annotationIntrospector != null && (v = this._annotationIntrospector.findFormat(this._classInfo)) != null) {
            return v;
        }
        return defValue;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> candidates = this._classInfo.getStaticMethods();
        if (candidates.isEmpty()) {
            return candidates;
        }
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod am : candidates) {
            if (!this.isFactoryMethod(am)) continue;
            result.add(am);
        }
        return result;
    }

    @Override
    public Constructor<?> findSingleArgConstructor(Class<?> ... argTypes) {
        for (AnnotatedConstructor ac : this._classInfo.getConstructors()) {
            if (ac.getParameterCount() != 1) continue;
            Class<?> actArg = ac.getRawParameterType(0);
            for (Class<?> expArg : argTypes) {
                if (expArg != actArg) continue;
                return ac.getAnnotated();
            }
        }
        return null;
    }

    @Override
    public Method findFactoryMethod(Class<?> ... expArgTypes) {
        for (AnnotatedMethod am : this._classInfo.getStaticMethods()) {
            if (!this.isFactoryMethod(am)) continue;
            Class<?> actualArgType = am.getRawParameterType(0);
            for (Class<?> expArgType : expArgTypes) {
                if (!actualArgType.isAssignableFrom(expArgType)) continue;
                return am.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz)) {
            return false;
        }
        if (this._annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            return true;
        }
        return "valueOf".equals(annotatedMethod.getName());
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(JsonInclude.Include defValue) {
        if (this._annotationIntrospector == null) {
            return defValue;
        }
        return this._annotationIntrospector.findSerializationInclusion(this._classInfo, defValue);
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        Class<?> clazz;
        if (this._anyGetter != null && !Map.class.isAssignableFrom(clazz = this._anyGetter.getRawType())) {
            throw new IllegalArgumentException("Invalid 'any-getter' annotation on method " + this._anyGetter.getName() + "(): return type is not instance of java.util.Map");
        }
        return this._anyGetter;
    }

    @Override
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        HashMap<String, AnnotatedMember> hashMap = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties) {
            String string;
            AnnotationIntrospector.ReferenceProperty referenceProperty;
            AnnotatedMember annotatedMember = beanPropertyDefinition.getMutator();
            if (annotatedMember == null || (referenceProperty = this._annotationIntrospector.findReferenceType(annotatedMember)) == null || !referenceProperty.isBackReference()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, AnnotatedMember>();
            }
            if (hashMap.put(string = referenceProperty.getName(), annotatedMember) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + string + "'");
        }
        return hashMap;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }
}

