/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.core.sym;

import com.amazonaws.com.fasterxml.jackson.core.sym.Name;
import com.amazonaws.com.fasterxml.jackson.core.sym.Name1;
import com.amazonaws.com.fasterxml.jackson.core.sym.Name2;
import com.amazonaws.com.fasterxml.jackson.core.sym.Name3;
import com.amazonaws.com.fasterxml.jackson.core.sym.NameN;
import com.amazonaws.com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class BytesToNameCanonicalizer {
    protected final BytesToNameCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    private final int _hashSeed;
    protected final boolean _intern;
    protected int _count;
    protected int _longestCollisionList;
    protected int _mainHashMask;
    protected int[] _mainHash;
    protected Name[] _mainNames;
    protected Bucket[] _collList;
    protected int _collCount;
    protected int _collEnd;
    private transient boolean _needRehash;
    private boolean _mainHashShared;
    private boolean _mainNamesShared;
    private boolean _collListShared;

    private BytesToNameCanonicalizer(int hashSize, boolean intern, int seed) {
        this._parent = null;
        this._hashSeed = seed;
        this._intern = intern;
        if (hashSize < 16) {
            hashSize = 16;
        } else if ((hashSize & hashSize - 1) != 0) {
            int curr;
            for (curr = 16; curr < hashSize; curr += curr) {
            }
            hashSize = curr;
        }
        this._tableInfo = new AtomicReference<TableInfo>(this.initTableInfo(hashSize));
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer parent, boolean intern, int seed, TableInfo state) {
        this._parent = parent;
        this._hashSeed = seed;
        this._intern = intern;
        this._tableInfo = null;
        this._count = state.count;
        this._mainHashMask = state.mainHashMask;
        this._mainHash = state.mainHash;
        this._mainNames = state.mainNames;
        this._collList = state.collList;
        this._collCount = state.collCount;
        this._collEnd = state.collEnd;
        this._longestCollisionList = state.longestCollisionList;
        this._needRehash = false;
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    private TableInfo initTableInfo(int hashSize) {
        return new TableInfo(0, hashSize - 1, new int[hashSize], new Name[hashSize], null, 0, 0, 0);
    }

    public static BytesToNameCanonicalizer createRoot() {
        long now = System.currentTimeMillis();
        int seed = (int)now + (int)(now >>> 32) | 1;
        return BytesToNameCanonicalizer.createRoot(seed);
    }

    protected static BytesToNameCanonicalizer createRoot(int hashSeed) {
        return new BytesToNameCanonicalizer(64, true, hashSeed);
    }

    public BytesToNameCanonicalizer makeChild(boolean canonicalize, boolean intern) {
        return new BytesToNameCanonicalizer(this, intern, this._hashSeed, this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._mainHashShared = true;
            this._mainNamesShared = true;
            this._collListShared = true;
        }
    }

    private void mergeChild(TableInfo childState) {
        int childCount = childState.count;
        TableInfo currState = this._tableInfo.get();
        if (childCount <= currState.count) {
            return;
        }
        if (childCount > 6000 || childState.longestCollisionList > 63) {
            childState = this.initTableInfo(64);
        }
        this._tableInfo.compareAndSet(currState, childState);
    }

    public boolean maybeDirty() {
        return !this._mainHashShared;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int firstQuad) {
        Bucket bucket;
        int hash = this.calcHash(firstQuad);
        int ix = hash & this._mainHashMask;
        int val = this._mainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(firstQuad)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, firstQuad, 0);
        }
        return null;
    }

    public Name findName(int firstQuad, int secondQuad) {
        Bucket bucket;
        int hash = secondQuad == 0 ? this.calcHash(firstQuad) : this.calcHash(firstQuad, secondQuad);
        int ix = hash & this._mainHashMask;
        int val = this._mainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null) {
                return null;
            }
            if (name.equals(firstQuad, secondQuad)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, firstQuad, secondQuad);
        }
        return null;
    }

    public Name findName(int[] quads, int qlen) {
        Bucket bucket;
        if (qlen < 3) {
            return this.findName(quads[0], qlen < 2 ? 0 : quads[1]);
        }
        int hash = this.calcHash(quads, qlen);
        int ix = hash & this._mainHashMask;
        int val = this._mainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            Name name = this._mainNames[ix];
            if (name == null || name.equals(quads, qlen)) {
                return name;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this._collList[--val]) != null) {
            return bucket.find(hash, quads, qlen);
        }
        return null;
    }

    public Name addName(String symbolStr, int[] quads, int qlen) {
        if (this._intern) {
            symbolStr = InternCache.instance.intern(symbolStr);
        }
        int hash = qlen < 3 ? (qlen == 1 ? this.calcHash(quads[0]) : this.calcHash(quads[0], quads[1])) : this.calcHash(quads, qlen);
        Name symbol = BytesToNameCanonicalizer.constructName(hash, symbolStr, quads, qlen);
        this._addSymbol(hash, symbol);
        return symbol;
    }

    public int calcHash(int firstQuad) {
        int hash = firstQuad ^ this._hashSeed;
        hash += hash >>> 15;
        hash ^= hash >>> 9;
        return hash;
    }

    public int calcHash(int firstQuad, int secondQuad) {
        int hash = firstQuad;
        hash ^= hash >>> 15;
        hash += secondQuad * 33;
        hash ^= this._hashSeed;
        hash += hash >>> 7;
        return hash;
    }

    public int calcHash(int[] quads, int qlen) {
        if (qlen < 3) {
            throw new IllegalArgumentException();
        }
        int hash = quads[0] ^ this._hashSeed;
        hash += hash >>> 9;
        hash *= 33;
        hash += quads[1];
        hash *= 65599;
        hash += hash >>> 15;
        hash ^= quads[2];
        hash += hash >>> 17;
        for (int i = 3; i < qlen; ++i) {
            hash = hash * 31 ^ quads[i];
            hash += hash >>> 3;
            hash ^= hash << 7;
        }
        hash += hash >>> 15;
        hash ^= hash << 9;
        return hash;
    }

    private void _addSymbol(int hash, Name symbol) {
        if (this._mainHashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        ++this._count;
        int ix = hash & this._mainHashMask;
        if (this._mainNames[ix] == null) {
            this._mainHash[ix] = hash << 8;
            if (this._mainNamesShared) {
                this.unshareNames();
            }
            this._mainNames[ix] = symbol;
        } else {
            Bucket newB;
            if (this._collListShared) {
                this.unshareCollision();
            }
            ++this._collCount;
            int entryValue = this._mainHash[ix];
            int bucket = entryValue & 0xFF;
            if (bucket == 0) {
                if (this._collEnd <= 254) {
                    if ((bucket = this._collEnd++) >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    bucket = this.findBestBucket();
                }
                this._mainHash[ix] = entryValue & 0xFFFFFF00 | bucket + 1;
            } else {
                --bucket;
            }
            this._collList[bucket] = newB = new Bucket(symbol, this._collList[bucket]);
            this._longestCollisionList = Math.max(newB.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        int hashSize = this._mainHash.length;
        if (this._count > hashSize >> 1) {
            int hashQuarter = hashSize >> 2;
            if (this._count > hashSize - hashQuarter) {
                this._needRehash = true;
            } else if (this._collCount >= hashQuarter) {
                this._needRehash = true;
            }
        }
    }

    private void rehash() {
        int n;
        int n2;
        this._needRehash = false;
        this._mainNamesShared = false;
        int[] nArray = this._mainHash;
        int n3 = nArray.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this.nukeSymbols();
            return;
        }
        this._mainHash = new int[n4];
        this._mainHashMask = n4 - 1;
        Name[] nameArray = this._mainNames;
        this._mainNames = new Name[n4];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Name name = nameArray[n2];
            if (name == null) continue;
            ++n5;
            int n6 = name.hashCode();
            n = n6 & this._mainHashMask;
            this._mainNames[n] = name;
            this._mainHash[n] = n6 << 8;
        }
        n2 = this._collEnd;
        if (n2 == 0) {
            this._longestCollisionList = 0;
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        int n7 = 0;
        Bucket[] bucketArray = this._collList;
        this._collList = new Bucket[bucketArray.length];
        for (n = 0; n < n2; ++n) {
            Bucket bucket = bucketArray[n];
            while (bucket != null) {
                ++n5;
                Name name = bucket._name;
                int n8 = name.hashCode();
                int n9 = n8 & this._mainHashMask;
                int n10 = this._mainHash[n9];
                if (this._mainNames[n9] == null) {
                    this._mainHash[n9] = n8 << 8;
                    this._mainNames[n9] = name;
                } else {
                    Bucket bucket2;
                    ++this._collCount;
                    int n11 = n10 & 0xFF;
                    if (n11 == 0) {
                        if (this._collEnd <= 254) {
                            if ((n11 = this._collEnd++) >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n11 = this.findBestBucket();
                        }
                        this._mainHash[n9] = n10 & 0xFFFFFF00 | n11 + 1;
                    } else {
                        --n11;
                    }
                    this._collList[n11] = bucket2 = new Bucket(name, this._collList[n11]);
                    n7 = Math.max(n7, bucket2.length());
                }
                bucket = bucket._next;
            }
        }
        this._longestCollisionList = n7;
        if (n5 != this._count) {
            throw new RuntimeException("Internal error: count after rehash " + n5 + "; should be " + this._count);
        }
    }

    private void nukeSymbols() {
        this._count = 0;
        this._longestCollisionList = 0;
        Arrays.fill(this._mainHash, 0);
        Arrays.fill(this._mainNames, null);
        Arrays.fill(this._collList, null);
        this._collCount = 0;
        this._collEnd = 0;
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this._collList;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = this._collEnd;
        for (int i = 0; i < n3; ++i) {
            int n4 = bucketArray[i].length();
            if (n4 >= n) continue;
            if (n4 == 1) {
                return i;
            }
            n = n4;
            n2 = i;
        }
        return n2;
    }

    private void unshareMain() {
        int[] old = this._mainHash;
        int len = this._mainHash.length;
        this._mainHash = new int[len];
        System.arraycopy(old, 0, this._mainHash, 0, len);
        this._mainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] old = this._collList;
        if (old == null) {
            this._collList = new Bucket[32];
        } else {
            int len = old.length;
            this._collList = new Bucket[len];
            System.arraycopy(old, 0, this._collList, 0, len);
        }
        this._collListShared = false;
    }

    private void unshareNames() {
        Name[] old = this._mainNames;
        int len = old.length;
        this._mainNames = new Name[len];
        System.arraycopy(old, 0, this._mainNames, 0, len);
        this._mainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] old = this._collList;
        int len = old.length;
        this._collList = new Bucket[len + len];
        System.arraycopy(old, 0, this._collList, 0, len);
    }

    private static Name constructName(int hash, String name, int[] quads, int qlen) {
        if (qlen < 4) {
            switch (qlen) {
                case 1: {
                    return new Name1(name, hash, quads[0]);
                }
                case 2: {
                    return new Name2(name, hash, quads[0], quads[1]);
                }
                case 3: {
                    return new Name3(name, hash, quads[0], quads[1], quads[2]);
                }
            }
        }
        int[] buf = new int[qlen];
        for (int i = 0; i < qlen; ++i) {
            buf[i] = quads[i];
        }
        return new NameN(name, hash, buf, qlen);
    }

    protected void reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._count + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }

    static final class Bucket {
        protected final Name _name;
        protected final Bucket _next;
        private final int _length;

        Bucket(Name name, Bucket next) {
            this._name = name;
            this._next = next;
            this._length = next == null ? 1 : next._length + 1;
        }

        public int length() {
            return this._length;
        }

        public Name find(int hash, int firstQuad, int secondQuad) {
            if (this._name.hashCode() == hash && this._name.equals(firstQuad, secondQuad)) {
                return this._name;
            }
            Bucket curr = this._next;
            while (curr != null) {
                Name currName = curr._name;
                if (currName.hashCode() == hash && currName.equals(firstQuad, secondQuad)) {
                    return currName;
                }
                curr = curr._next;
            }
            return null;
        }

        public Name find(int hash, int[] quads, int qlen) {
            if (this._name.hashCode() == hash && this._name.equals(quads, qlen)) {
                return this._name;
            }
            Bucket curr = this._next;
            while (curr != null) {
                Name currName = curr._name;
                if (currName.hashCode() == hash && currName.equals(quads, qlen)) {
                    return currName;
                }
                curr = curr._next;
            }
            return null;
        }
    }

    private static final class TableInfo {
        public final int count;
        public final int mainHashMask;
        public final int[] mainHash;
        public final Name[] mainNames;
        public final Bucket[] collList;
        public final int collCount;
        public final int collEnd;
        public final int longestCollisionList;

        public TableInfo(int count, int mainHashMask, int[] mainHash, Name[] mainNames, Bucket[] collList, int collCount, int collEnd, int longestCollisionList) {
            this.count = count;
            this.mainHashMask = mainHashMask;
            this.mainHash = mainHash;
            this.mainNames = mainNames;
            this.collList = collList;
            this.collCount = collCount;
            this.collEnd = collEnd;
            this.longestCollisionList = longestCollisionList;
        }

        public TableInfo(BytesToNameCanonicalizer src) {
            this.count = src._count;
            this.mainHashMask = src._mainHashMask;
            this.mainHash = src._mainHash;
            this.mainNames = src._mainNames;
            this.collList = src._collList;
            this.collCount = src._collCount;
            this.collEnd = src._collEnd;
            this.longestCollisionList = src._longestCollisionList;
        }
    }
}

