/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    protected StandardErrorUnmarshaller(Class<? extends AmazonServiceException> clazz) {
        super(clazz);
    }

    @Override
    public AmazonServiceException unmarshall(Node node) throws Exception {
        String string = this.parseErrorCode(node);
        String string2 = XpathUtils.asString("ErrorResponse/Error/Type", node);
        String string3 = XpathUtils.asString("ErrorResponse/RequestId", node);
        String string4 = XpathUtils.asString("ErrorResponse/Error/Message", node);
        AmazonServiceException amazonServiceException = this.newException(string4);
        amazonServiceException.setErrorCode(string);
        amazonServiceException.setRequestId(string3);
        if (string2 == null) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if (string2.equalsIgnoreCase("Receiver")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if (string2.equalsIgnoreCase("Sender")) {
            amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return amazonServiceException;
    }

    public String parseErrorCode(Node node) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", node);
    }

    public String getErrorPropertyPath(String string) {
        return "ErrorResponse/Error/" + string;
    }
}

