/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsync;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageResult;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSSecurityTokenServiceAsyncClient
extends AWSSecurityTokenServiceClient
implements AWSSecurityTokenServiceAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSSecurityTokenServiceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSSecurityTokenServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials aWSCredentials, ExecutorService executorService) {
        super(aWSCredentials);
        this.executorService = executorService;
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ExecutorService executorService) {
        this(aWSCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(final GetSessionTokenRequest getSessionTokenRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.getSessionToken(getSessionTokenRequest);
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(final GetSessionTokenRequest getSessionTokenRequest, final AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                GetSessionTokenResult getSessionTokenResult;
                try {
                    getSessionTokenResult = AWSSecurityTokenServiceAsyncClient.this.getSessionToken(getSessionTokenRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(getSessionTokenRequest, getSessionTokenResult);
                return getSessionTokenResult;
            }
        });
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(final DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DecodeAuthorizationMessageResult>(){

            @Override
            public DecodeAuthorizationMessageResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.decodeAuthorizationMessage(decodeAuthorizationMessageRequest);
            }
        });
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(final DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest, final AsyncHandler<DecodeAuthorizationMessageRequest, DecodeAuthorizationMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DecodeAuthorizationMessageResult>(){

            @Override
            public DecodeAuthorizationMessageResult call() throws Exception {
                DecodeAuthorizationMessageResult decodeAuthorizationMessageResult;
                try {
                    decodeAuthorizationMessageResult = AWSSecurityTokenServiceAsyncClient.this.decodeAuthorizationMessage(decodeAuthorizationMessageRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(decodeAuthorizationMessageRequest, decodeAuthorizationMessageResult);
                return decodeAuthorizationMessageResult;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(final AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithSAMLResult>(){

            @Override
            public AssumeRoleWithSAMLResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithSAML(assumeRoleWithSAMLRequest);
            }
        });
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(final AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest, final AsyncHandler<AssumeRoleWithSAMLRequest, AssumeRoleWithSAMLResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithSAMLResult>(){

            @Override
            public AssumeRoleWithSAMLResult call() throws Exception {
                AssumeRoleWithSAMLResult assumeRoleWithSAMLResult;
                try {
                    assumeRoleWithSAMLResult = AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithSAML(assumeRoleWithSAMLRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(assumeRoleWithSAMLRequest, assumeRoleWithSAMLResult);
                return assumeRoleWithSAMLResult;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(final AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(final AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest, final AsyncHandler<AssumeRoleWithWebIdentityRequest, AssumeRoleWithWebIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult;
                try {
                    assumeRoleWithWebIdentityResult = AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(assumeRoleWithWebIdentityRequest, assumeRoleWithWebIdentityResult);
                return assumeRoleWithWebIdentityResult;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(final GetFederationTokenRequest getFederationTokenRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.getFederationToken(getFederationTokenRequest);
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(final GetFederationTokenRequest getFederationTokenRequest, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult getFederationTokenResult;
                try {
                    getFederationTokenResult = AWSSecurityTokenServiceAsyncClient.this.getFederationToken(getFederationTokenRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(getFederationTokenRequest, getFederationTokenResult);
                return getFederationTokenResult;
            }
        });
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(final AssumeRoleRequest assumeRoleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.assumeRole(assumeRoleRequest);
            }
        });
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(final AssumeRoleRequest assumeRoleRequest, final AsyncHandler<AssumeRoleRequest, AssumeRoleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                AssumeRoleResult assumeRoleResult;
                try {
                    assumeRoleResult = AWSSecurityTokenServiceAsyncClient.this.assumeRole(assumeRoleRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess(assumeRoleRequest, assumeRoleResult);
                return assumeRoleResult;
            }
        });
    }
}

