/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.Request;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.metrics.MetricInputStreamEntity;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.metrics.internal.ServiceMetricTypeGuesser;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.entity.BasicHttpEntity;
import com.amazonaws.org.apache.http.entity.InputStreamEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Log log = LogFactory.getLog(AmazonHttpClient.class);
    private IOException originalException;

    RepeatableInputStreamRequestEntity(Request<?> request) {
        String string;
        this.setChunked(false);
        long l = -1L;
        try {
            string = request.getHeaders().get("Content-Length");
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Unable to parse content length from request.  Buffering contents in memory.");
        }
        string = request.getHeaders().get("Content-Type");
        ThroughputMetricType throughputMetricType = ServiceMetricTypeGuesser.guessThroughputMetricType(request, "UploadThroughput", "UploadByteCount");
        this.inputStreamRequestEntity = throughputMetricType == null ? new InputStreamEntity(request.getContent(), l) : new MetricInputStreamEntity(throughputMetricType, request.getContent(), l);
        this.inputStreamRequestEntity.setContentType(string);
        this.content = request.getContent();
        this.setContent(this.content);
        this.setContentType(string);
        this.setContentLength(l);
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            this.inputStreamRequestEntity.writeTo(outputStream);
        }
        catch (IOException iOException) {
            if (this.originalException == null) {
                this.originalException = iOException;
            }
            throw this.originalException;
        }
    }
}

