/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.json.AwsJsonFactory;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.AwsJsonToken;
import com.amazonaws.util.json.AwsJsonWriter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;

final class JacksonFactory
implements AwsJsonFactory {
    private final JsonFactory factory = new JsonFactory();

    JacksonFactory() {
    }

    @Override
    public AwsJsonReader getJsonReader(Reader in) {
        return new JacksonReader(this.factory, in);
    }

    @Override
    public AwsJsonWriter getJsonWriter(Writer out) {
        return new JacksonWriter(this.factory, out);
    }

    private static AwsJsonToken convert(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case START_ARRAY: {
                return AwsJsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return AwsJsonToken.END_ARRAY;
            }
            case START_OBJECT: {
                return AwsJsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return AwsJsonToken.END_OBJECT;
            }
            case FIELD_NAME: {
                return AwsJsonToken.FIELD_NAME;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return AwsJsonToken.VALUE_BOOLEAN;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return AwsJsonToken.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return AwsJsonToken.VALUE_NULL;
            }
            case VALUE_STRING: {
                return AwsJsonToken.VALUE_STRING;
            }
        }
        return AwsJsonToken.UNKNOWN;
    }

    private static final class JacksonWriter
    implements AwsJsonWriter {
        private JsonGenerator writer;

        public JacksonWriter(JsonFactory factory, Writer out) {
            try {
                this.writer = factory.createGenerator(out);
            }
            catch (IOException e) {
                throw new AmazonClientException("Failed to create json writer", e);
            }
        }

        @Override
        public AwsJsonWriter beginArray() throws IOException {
            this.writer.writeStartArray();
            return this;
        }

        @Override
        public AwsJsonWriter endArray() throws IOException {
            this.writer.writeEndArray();
            return this;
        }

        @Override
        public AwsJsonWriter beginObject() throws IOException {
            this.writer.writeStartObject();
            return this;
        }

        @Override
        public AwsJsonWriter endObject() throws IOException {
            this.writer.writeEndObject();
            return this;
        }

        @Override
        public AwsJsonWriter name(String name) throws IOException {
            this.writer.writeFieldName(name);
            return this;
        }

        @Override
        public AwsJsonWriter value(String value) throws IOException {
            this.writer.writeString(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(boolean value) throws IOException {
            this.writer.writeBoolean(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(double value) throws IOException {
            this.writer.writeNumber(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(long value) throws IOException {
            this.writer.writeNumber(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(Number value) throws IOException {
            this.writer.writeNumber(value.toString());
            return this;
        }

        @Override
        public AwsJsonWriter value(Date value) throws IOException {
            BigDecimal dateValue = BigDecimal.valueOf(value.getTime());
            this.writer.writeNumber(dateValue.scaleByPowerOfTen(-3).toPlainString());
            return this;
        }

        @Override
        public AwsJsonWriter value(ByteBuffer value) throws IOException {
            value.mark();
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes, 0, bytes.length);
            value.reset();
            this.writer.writeString(BinaryUtils.toBase64(bytes));
            return this;
        }

        @Override
        public AwsJsonWriter value() throws IOException {
            this.writer.writeNull();
            return this;
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static final class JacksonReader
    implements AwsJsonReader {
        private JsonParser reader;
        private JsonToken nextToken = null;

        public JacksonReader(JsonFactory factory, Reader in) {
            try {
                this.reader = factory.createJsonParser(in);
            }
            catch (IOException e) {
                throw new AmazonClientException("Failed to create Json reader", e);
            }
        }

        @Override
        public void beginArray() throws IOException {
            this.nextToken();
            this.expect(JsonToken.START_ARRAY);
            this.clearToken();
        }

        @Override
        public void endArray() throws IOException {
            this.nextToken();
            this.expect(JsonToken.END_ARRAY);
            this.clearToken();
        }

        @Override
        public void beginObject() throws IOException {
            this.nextToken();
            this.expect(JsonToken.START_OBJECT);
            this.clearToken();
        }

        @Override
        public void endObject() throws IOException {
            this.nextToken();
            this.expect(JsonToken.END_OBJECT);
            this.clearToken();
        }

        @Override
        public boolean isContainer() throws IOException {
            this.nextToken();
            return JsonToken.START_ARRAY == this.nextToken || JsonToken.START_OBJECT == this.nextToken;
        }

        @Override
        public boolean hasNext() throws IOException {
            this.nextToken();
            return JsonToken.END_OBJECT != this.nextToken && JsonToken.END_ARRAY != this.nextToken;
        }

        @Override
        public String nextName() throws IOException {
            this.nextToken();
            this.expect(JsonToken.FIELD_NAME);
            this.clearToken();
            return this.reader.getText();
        }

        @Override
        public String nextString() throws IOException {
            this.nextToken();
            String s = JsonToken.VALUE_NULL == this.nextToken ? null : this.reader.getText();
            this.clearToken();
            return s;
        }

        @Override
        public AwsJsonToken peek() throws IOException {
            this.nextToken();
            return JacksonFactory.convert(this.nextToken);
        }

        @Override
        public void skipValue() throws IOException {
            this.nextToken();
            this.reader.skipChildren();
            this.clearToken();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        private void nextToken() throws IOException {
            if (this.nextToken == null) {
                this.nextToken = this.reader.nextToken();
            }
        }

        private void clearToken() throws IOException {
            this.nextToken = null;
        }

        private void expect(JsonToken token) throws IOException {
            if (this.nextToken != token) {
                throw new IOException("Expected " + token + " but was " + token);
            }
        }
    }
}

