/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionDefaults;
import com.amazonaws.regions.RegionMetadataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;

public class RegionUtils {
    private static final String FALLBACK = "regions.xml";
    private static List<Region> regions;
    private static final Log log;

    public static synchronized List<Region> getRegions() {
        if (regions == null) {
            RegionUtils.init();
        }
        return regions;
    }

    public static synchronized List<Region> getRegionsForService(String serviceAbbreviation) {
        LinkedList<Region> regions = new LinkedList<Region>();
        for (Region r : RegionUtils.getRegions()) {
            if (!r.isServiceSupported(serviceAbbreviation)) continue;
            regions.add(r);
        }
        return regions;
    }

    public static Region getRegion(String regionName) {
        for (Region r : RegionUtils.getRegions()) {
            if (!r.getName().equals(regionName)) continue;
            return r;
        }
        return null;
    }

    public static Region getRegionByEndpoint(String endpoint) {
        URI targetEndpointUri = RegionUtils.getUriByEndpoint(endpoint);
        String targetHost = targetEndpointUri.getHost();
        for (Region region : RegionUtils.getRegions()) {
            for (String serviceEndpoint : region.getServiceEndpoints().values()) {
                URI serviceEndpointUrl = RegionUtils.getUriByEndpoint(serviceEndpoint);
                if (!serviceEndpointUrl.getHost().equals(targetHost)) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    public static synchronized void init() {
        if (System.getProperty("com.amazonaws.regions.RegionUtils.fileOverride") != null) {
            try {
                RegionUtils.loadRegionsFromOverrideFile();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Couldn't find regions override file specified", e);
            }
        }
        if (regions == null) {
            RegionUtils.initSDKRegions();
        }
        if (regions == null) {
            throw new RuntimeException("Failed to initialize the regions.");
        }
    }

    private static void loadRegionsFromOverrideFile() throws FileNotFoundException {
        String overrideFilePath = System.getProperty("com.amazonaws.regions.RegionUtils.fileOverride");
        if (log.isDebugEnabled()) {
            log.debug("Using local override of the regions file (" + overrideFilePath + ") to initiate regions data...");
        }
        File regionsFile = new File(overrideFilePath);
        FileInputStream override = new FileInputStream(regionsFile);
        RegionUtils.initRegions(override);
    }

    private static void initRegions(InputStream regionsFile) {
        try {
            RegionMetadataParser parser = new RegionMetadataParser();
            regions = parser.parseRegionMetadata(regionsFile);
        }
        catch (Exception e) {
            log.warn("Failed to parse regional endpoints", e);
        }
    }

    private static void initSDKRegions() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing the regions with default regions");
        }
        regions = RegionDefaults.getRegions();
    }

    private static URI getUriByEndpoint(String endpoint) {
        URI targetEndpointUri = null;
        try {
            targetEndpointUri = new URI(endpoint);
            if (targetEndpointUri.getHost() == null) {
                targetEndpointUri = new URI("http://" + endpoint);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage());
        }
        return targetEndpointUri;
    }

    static {
        log = LogFactory.getLog("com.amazonaws.request");
    }
}

