/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.UserType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonUnmarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.MFAOptionTypeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class UserTypeJsonUnmarshaller
implements Unmarshaller<UserType, JsonUnmarshallerContext> {
    private static UserTypeJsonUnmarshaller instance;

    UserTypeJsonUnmarshaller() {
    }

    public UserType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        UserType userType = new UserType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Username")) {
                userType.setUsername(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Attributes")) {
                userType.setAttributes(new ListUnmarshaller((Unmarshaller)AttributeTypeJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("UserCreateDate")) {
                userType.setUserCreateDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("UserLastModifiedDate")) {
                userType.setUserLastModifiedDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Enabled")) {
                userType.setEnabled(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("UserStatus")) {
                userType.setUserStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("MFAOptions")) {
                userType.setMFAOptions(new ListUnmarshaller((Unmarshaller)MFAOptionTypeJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return userType;
    }

    public static UserTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new UserTypeJsonUnmarshaller();
        }
        return instance;
    }
}

