/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class UpdateUserAttributesRequestMarshaller
implements Marshaller<Request<UpdateUserAttributesRequest>, UpdateUserAttributesRequest> {
    public Request<UpdateUserAttributesRequest> marshall(UpdateUserAttributesRequest updateUserAttributesRequest) {
        if (updateUserAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateUserAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserAttributesRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateUserAttributes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateUserAttributesRequest.getUserAttributes() != null) {
                List<AttributeType> userAttributes = updateUserAttributesRequest.getUserAttributes();
                jsonWriter.name("UserAttributes");
                jsonWriter.beginArray();
                for (AttributeType attributeType : userAttributes) {
                    if (attributeType == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributeType, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateUserAttributesRequest.getAccessToken() != null) {
                String accessToken = updateUserAttributesRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (updateUserAttributesRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = updateUserAttributesRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry entry : clientMetadata.entrySet()) {
                    String clientMetadataValue = (String)entry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

