/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ResourceServerScopeTypeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class ResourceServerTypeJsonUnmarshaller
implements Unmarshaller<ResourceServerType, JsonUnmarshallerContext> {
    private static ResourceServerTypeJsonUnmarshaller instance;

    ResourceServerTypeJsonUnmarshaller() {
    }

    public ResourceServerType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        ResourceServerType resourceServerType = new ResourceServerType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("UserPoolId")) {
                resourceServerType.setUserPoolId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Identifier")) {
                resourceServerType.setIdentifier(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Name")) {
                resourceServerType.setName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Scopes")) {
                resourceServerType.setScopes(new ListUnmarshaller((Unmarshaller)ResourceServerScopeTypeJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return resourceServerType;
    }

    public static ResourceServerTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceServerTypeJsonUnmarshaller();
        }
        return instance;
    }
}

