/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class CreateIdentityProviderRequestMarshaller
implements Marshaller<Request<CreateIdentityProviderRequest>, CreateIdentityProviderRequest> {
    public Request<CreateIdentityProviderRequest> marshall(CreateIdentityProviderRequest createIdentityProviderRequest) {
        if (createIdentityProviderRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateIdentityProviderRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIdentityProviderRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.CreateIdentityProvider";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createIdentityProviderRequest.getUserPoolId() != null) {
                String userPoolId = createIdentityProviderRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (createIdentityProviderRequest.getProviderName() != null) {
                String providerName = createIdentityProviderRequest.getProviderName();
                jsonWriter.name("ProviderName");
                jsonWriter.value(providerName);
            }
            if (createIdentityProviderRequest.getProviderType() != null) {
                String providerType = createIdentityProviderRequest.getProviderType();
                jsonWriter.name("ProviderType");
                jsonWriter.value(providerType);
            }
            if (createIdentityProviderRequest.getProviderDetails() != null) {
                Map<String, String> providerDetails = createIdentityProviderRequest.getProviderDetails();
                jsonWriter.name("ProviderDetails");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> entry : providerDetails.entrySet()) {
                    String providerDetailsValue = entry.getValue();
                    if (providerDetailsValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    jsonWriter.value(providerDetailsValue);
                }
                jsonWriter.endObject();
            }
            if (createIdentityProviderRequest.getAttributeMapping() != null) {
                Map<String, String> attributeMapping = createIdentityProviderRequest.getAttributeMapping();
                jsonWriter.name("AttributeMapping");
                jsonWriter.beginObject();
                for (Map.Entry entry : attributeMapping.entrySet()) {
                    String attributeMappingValue = (String)entry.getValue();
                    if (attributeMappingValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(attributeMappingValue);
                }
                jsonWriter.endObject();
            }
            if (createIdentityProviderRequest.getIdpIdentifiers() != null) {
                List<String> idpIdentifiers = createIdentityProviderRequest.getIdpIdentifiers();
                jsonWriter.name("IdpIdentifiers");
                jsonWriter.beginArray();
                for (String string : idpIdentifiers) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

