/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SignUpRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clientId;
    private String secretHash;
    private String username;
    private String password;
    private List<AttributeType> userAttributes;
    private List<AttributeType> validationData;
    private UserContextDataType userContextData;
    private AnalyticsMetadataType analyticsMetadata;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignUpRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getSecretHash() {
        return this.secretHash;
    }

    public void setSecretHash(String secretHash) {
        this.secretHash = secretHash;
    }

    public SignUpRequest withSecretHash(String secretHash) {
        this.secretHash = secretHash;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SignUpRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SignUpRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public SignUpRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.userAttributes = new ArrayList<AttributeType>(userAttributes.length);
        }
        for (AttributeType value : userAttributes) {
            this.userAttributes.add(value);
        }
        return this;
    }

    public SignUpRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public List<AttributeType> getValidationData() {
        return this.validationData;
    }

    public void setValidationData(Collection<AttributeType> validationData) {
        if (validationData == null) {
            this.validationData = null;
            return;
        }
        this.validationData = new ArrayList<AttributeType>(validationData);
    }

    public SignUpRequest withValidationData(AttributeType ... validationData) {
        if (this.getValidationData() == null) {
            this.validationData = new ArrayList<AttributeType>(validationData.length);
        }
        for (AttributeType value : validationData) {
            this.validationData.add(value);
        }
        return this;
    }

    public SignUpRequest withValidationData(Collection<AttributeType> validationData) {
        this.setValidationData(validationData);
        return this;
    }

    public UserContextDataType getUserContextData() {
        return this.userContextData;
    }

    public void setUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
    }

    public SignUpRequest withUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
        return this;
    }

    public AnalyticsMetadataType getAnalyticsMetadata() {
        return this.analyticsMetadata;
    }

    public void setAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
    }

    public SignUpRequest withAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: " + this.getClientId() + ",");
        }
        if (this.getSecretHash() != null) {
            sb.append("SecretHash: " + this.getSecretHash() + ",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: " + this.getPassword() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getValidationData() != null) {
            sb.append("ValidationData: " + this.getValidationData() + ",");
        }
        if (this.getUserContextData() != null) {
            sb.append("UserContextData: " + this.getUserContextData() + ",");
        }
        if (this.getAnalyticsMetadata() != null) {
            sb.append("AnalyticsMetadata: " + this.getAnalyticsMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getSecretHash() == null ? 0 : this.getSecretHash().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getValidationData() == null ? 0 : this.getValidationData().hashCode());
        hashCode = 31 * hashCode + (this.getUserContextData() == null ? 0 : this.getUserContextData().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyticsMetadata() == null ? 0 : this.getAnalyticsMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpRequest)) {
            return false;
        }
        SignUpRequest other = (SignUpRequest)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getSecretHash() == null ^ this.getSecretHash() == null) {
            return false;
        }
        if (other.getSecretHash() != null && !other.getSecretHash().equals(this.getSecretHash())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getValidationData() == null ^ this.getValidationData() == null) {
            return false;
        }
        if (other.getValidationData() != null && !other.getValidationData().equals(this.getValidationData())) {
            return false;
        }
        if (other.getUserContextData() == null ^ this.getUserContextData() == null) {
            return false;
        }
        if (other.getUserContextData() != null && !other.getUserContextData().equals(this.getUserContextData())) {
            return false;
        }
        if (other.getAnalyticsMetadata() == null ^ this.getAnalyticsMetadata() == null) {
            return false;
        }
        return other.getAnalyticsMetadata() == null || other.getAnalyticsMetadata().equals(this.getAnalyticsMetadata());
    }
}

