/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cognito.clientcontext.data;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.amazonaws.cognito.clientcontext.data.ConfigurationConstant;
import com.amazonaws.cognito.clientcontext.datacollection.ContextDataAggregator;
import com.amazonaws.cognito.clientcontext.util.SignatureGenerator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UserContextDataProvider {
    private static final String TAG = UserContextDataProvider.class.getSimpleName();
    public static final String VERSION = "ANDROID20171114";
    private ContextDataAggregator aggregator;
    private SignatureGenerator signatureGenerator;

    private UserContextDataProvider() {
        this(ContextDataAggregator.getInstance(), new SignatureGenerator());
    }

    protected UserContextDataProvider(ContextDataAggregator aggregator, SignatureGenerator signatureGenerator) {
        this.aggregator = aggregator;
        this.signatureGenerator = signatureGenerator;
    }

    public static UserContextDataProvider getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public String getEncodedContextData(Context context, String username, String userPoolId, String signatureSecret) {
        JSONObject jsonResponse = new JSONObject();
        try {
            Map<String, String> contextData = this.aggregator.getAggregatedData(context);
            JSONObject payload = this.getJsonPayload(contextData, username, userPoolId);
            String payloadString = payload.toString();
            String signature = this.signatureGenerator.getSignature(payloadString, signatureSecret, VERSION);
            jsonResponse = this.getJsonResponse(payloadString, signature);
            return this.getEncodedResponse(jsonResponse);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception in creating JSON from context data");
            return null;
        }
    }

    private JSONObject getJsonPayload(Map<String, String> contextData, String username, String userPoolId) throws JSONException {
        JSONObject payload = new JSONObject();
        payload.put("contextData", (Object)new JSONObject(contextData));
        payload.put("username", (Object)username);
        payload.put("userPoolId", (Object)userPoolId);
        payload.put("timestamp", (Object)this.getTimestamp());
        return payload;
    }

    protected String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private JSONObject getJsonResponse(String payload, String signature) throws JSONException {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("payload", (Object)payload);
        jsonResponse.put("signature", (Object)signature);
        jsonResponse.put("version", (Object)VERSION);
        return jsonResponse;
    }

    protected String getEncodedResponse(JSONObject jsonResponse) {
        byte[] responseBytes = jsonResponse.toString().getBytes(ConfigurationConstant.DEFAULT_CHARSET);
        return Base64.encodeToString((byte[])responseBytes, (int)0);
    }

    private class ContextDataJsonKeys {
        private static final String CONTEXT_DATA = "contextData";
        private static final String USERNAME = "username";
        private static final String USER_POOL_ID = "userPoolId";
        private static final String TIMESTAMP_MILLI_SEC = "timestamp";
        private static final String DATA_PAYLOAD = "payload";
        private static final String VERSION = "version";
        private static final String SIGNATURE = "signature";

        private ContextDataJsonKeys() {
        }
    }

    private static class InstanceHolder {
        private static final UserContextDataProvider INSTANCE = new UserContextDataProvider();

        private InstanceHolder() {
        }
    }
}

