/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.RegisterMfaHandler;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class VerifyMfaContinuation
implements CognitoIdentityProviderContinuation<Map<String, String>> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final Context context;
    private final String clientId;
    private final CognitoUser user;
    private final RegisterMfaHandler callback;
    private final Map<String, String> mfaSetupDetails;
    private final boolean useSessionToken;
    private final String sessionToken;
    private final boolean runInBackground;
    private String verificationCode;
    private String friendlyName = "Time-based One-time Password MFA";

    public VerifyMfaContinuation(Context context, String clientId, CognitoUser user, RegisterMfaHandler callback, Map<String, String> mfaSetupDetails, boolean useSessionToken, String sessionToken, boolean runInBackground) {
        this.context = context;
        this.clientId = clientId;
        this.user = user;
        this.callback = callback;
        this.mfaSetupDetails = mfaSetupDetails;
        this.useSessionToken = useSessionToken;
        this.sessionToken = sessionToken;
        this.runInBackground = runInBackground;
    }

    public void setVerificationResponse(String mfaVerificationCode, String mfaFriendlyName) {
        if (StringUtils.isBlank((CharSequence)mfaVerificationCode)) {
            throw new CognitoParameterInvalidException("verification code is invalid");
        }
        this.verificationCode = mfaVerificationCode;
        if (!StringUtils.isBlank((CharSequence)mfaFriendlyName)) {
            this.friendlyName = mfaFriendlyName;
        }
    }

    @Override
    public Map<String, String> getParameters() {
        return this.mfaSetupDetails;
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            if (this.useSessionToken) {
                this.user.verifySoftwareTokenInBackground(this.sessionToken, this.verificationCode, this.friendlyName, this.callback);
            } else {
                this.user.verifySoftwareTokenInBackground(null, this.verificationCode, this.friendlyName, this.callback);
            }
        } else {
            this.user.verifySoftwareTokenInBackground(null, this.verificationCode, this.friendlyName, this.callback);
        }
    }
}

