/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.cognito.clientcontext.data.UserContextDataProvider;
import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoDeviceHelper;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoPinpointSharedContext;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoSecretHash;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.SignUpRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SignUpResult;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class CognitoUserPool {
    private static final Log logger = LogFactory.getLog(CognitoUserPool.class);
    private static final int USER_POOL_ID_MAX_LENGTH = 55;
    private static final String USER_POOL_ID_PATTERN = "^[\\w-]+_[0-9a-zA-Z]+$";
    private final String userPoolId;
    private final String clientId;
    private final String clientSecret;
    private final Context context;
    private AmazonCognitoIdentityProvider client;
    private String secretHash;
    private String pinpointEndpointId;
    private boolean advancedSecurityDataCollectionFlag = true;
    private boolean isPersistenceEnabled = true;
    private static final String DEFAULT_SHARED_PREFERENCES_NAME = "CognitoIdentityProviderCache";
    AWSKeyValueStore awsKeyValueStore;

    @Deprecated
    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, ClientConfiguration clientConfiguration) {
        this(context, userPoolId, clientId, clientSecret, clientConfiguration, Regions.US_EAST_1);
    }

    @Deprecated
    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret) {
        this(context, userPoolId, clientId, clientSecret, new ClientConfiguration(), Regions.US_EAST_1);
    }

    public CognitoUserPool(Context context, AWSConfiguration awsConfiguration) {
        try {
            this.initialize(context);
            JSONObject userPoolConfiguration = awsConfiguration.optJsonObject("CognitoUserPool");
            this.context = context;
            this.userPoolId = userPoolConfiguration.getString("PoolId");
            this.clientId = userPoolConfiguration.getString("AppClientId");
            this.clientSecret = userPoolConfiguration.optString("AppClientSecret");
            this.pinpointEndpointId = CognitoPinpointSharedContext.getPinpointEndpoint(context, userPoolConfiguration.optString("PinpointAppId"));
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setUserAgent(awsConfiguration.getUserAgent());
            clientConfig.setUserAgentOverride(awsConfiguration.getUserAgentOverride());
            this.client = new AmazonCognitoIdentityProviderClient((AWSCredentials)new AnonymousAWSCredentials(), clientConfig);
            this.client.setRegion(Region.getRegion((Regions)Regions.fromName((String)userPoolConfiguration.getString("Region"))));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read PoolId, AppClientId, AppClientSecret, or Region from AWSConfiguration please check your setup or awsconfiguration.json file", e);
        }
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, Regions region) {
        this(context, userPoolId, clientId, clientSecret, new ClientConfiguration(), region);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, Regions region, String pinpointAppId) {
        this(context, userPoolId, clientId, clientSecret, new ClientConfiguration(), region, pinpointAppId);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, ClientConfiguration clientConfiguration, Regions region) {
        this(context, userPoolId, clientId, clientSecret, clientConfiguration, region, null);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, ClientConfiguration clientConfiguration, Regions region, String pinpointAppId) {
        this.initialize(context);
        this.context = context;
        if (userPoolId.isEmpty() || clientId.isEmpty()) {
            throw new IllegalArgumentException("Both UserPoolId and ClientId are required.");
        }
        if (userPoolId.length() > 55 || !Pattern.matches(USER_POOL_ID_PATTERN, userPoolId)) {
            throw new IllegalArgumentException("Invalid userPoolId format.");
        }
        this.userPoolId = userPoolId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = new AmazonCognitoIdentityProviderClient((AWSCredentials)new AnonymousAWSCredentials(), clientConfiguration);
        this.client.setRegion(Region.getRegion((Regions)region));
        this.pinpointEndpointId = CognitoPinpointSharedContext.getPinpointEndpoint(context, pinpointAppId);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, AmazonCognitoIdentityProvider client) {
        this(context, userPoolId, clientId, clientSecret, client, null);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, AmazonCognitoIdentityProvider client, String pinpointAppId) {
        this(context, userPoolId, clientId, clientSecret, client, pinpointAppId, null);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, AmazonCognitoIdentityProvider client, String pinpointAppId, String cognitoUserPoolCustomEndpoint) {
        this.initialize(context);
        this.context = context;
        if (userPoolId.isEmpty() || clientId.isEmpty()) {
            throw new IllegalArgumentException("Both UserPoolId and ClientId are required.");
        }
        if (userPoolId.length() > 55 || !Pattern.matches(USER_POOL_ID_PATTERN, userPoolId)) {
            throw new IllegalArgumentException("Invalid userPoolId format.");
        }
        this.userPoolId = userPoolId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = client;
        this.pinpointEndpointId = CognitoPinpointSharedContext.getPinpointEndpoint(context, pinpointAppId);
        if (cognitoUserPoolCustomEndpoint != null && !cognitoUserPoolCustomEndpoint.isEmpty()) {
            this.client.setEndpoint(cognitoUserPoolCustomEndpoint);
        }
    }

    @VisibleForTesting
    void setIdentityProvider(AmazonCognitoIdentityProvider userpool) {
        this.client = userpool;
    }

    private void initialize(Context context) {
        this.awsKeyValueStore = new AWSKeyValueStore(context, DEFAULT_SHARED_PREFERENCES_NAME, this.isPersistenceEnabled);
        CognitoDeviceHelper.setPersistenceEnabled(this.isPersistenceEnabled);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setAdvancedSecurityDataCollectionFlag(boolean isEnabled) {
        this.advancedSecurityDataCollectionFlag = isEnabled;
    }

    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.awsKeyValueStore.setPersistenceEnabled(this.isPersistenceEnabled);
        CognitoDeviceHelper.setPersistenceEnabled(isPersistenceEnabled);
    }

    public void signUpInBackground(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData, SignUpHandler callback) {
        this.signUpInBackground(userId, password, userAttributes, validationData, Collections.emptyMap(), callback);
    }

    public void signUp(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData, SignUpHandler callback) {
        this.signUp(userId, password, userAttributes, validationData, Collections.emptyMap(), callback);
    }

    public void signUpInBackground(final String userId, final String password, final CognitoUserAttributes userAttributes, final Map<String, String> validationData, final Map<String, String> clientMetadata, final SignUpHandler callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUserPool.this.context.getMainLooper());
                try {
                    final SignUpResult signUpResult = CognitoUserPool.this.signUpInternal(userId, password, userAttributes, validationData, clientMetadata);
                    final CognitoUser user = CognitoUserPool.this.getUser(userId);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(user, signUpResult);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void signUp(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData, Map<String, String> clientMetadata, SignUpHandler callback) {
        try {
            SignUpResult signUpResult = this.signUpInternal(userId, password, userAttributes, validationData, clientMetadata);
            CognitoUser user = this.getUser(userId);
            callback.onSuccess(user, signUpResult);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private SignUpResult signUpInternal(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData, Map<String, String> clientMetadata) {
        ArrayList<AttributeType> validationDataList = null;
        if (validationData != null) {
            validationDataList = new ArrayList<AttributeType>();
            for (Map.Entry<String, String> data : validationData.entrySet()) {
                AttributeType validation = new AttributeType();
                validation.setName(data.getKey());
                validation.setValue(data.getValue());
                validationDataList.add(validation);
            }
        }
        this.secretHash = CognitoSecretHash.getSecretHash(userId, this.clientId, this.clientSecret);
        SignUpRequest signUpUserRequest = new SignUpRequest().withUsername(userId).withPassword(password).withClientId(this.clientId).withSecretHash(this.secretHash).withUserAttributes(userAttributes.getAttributesList()).withValidationData(validationDataList).withClientMetadata(clientMetadata).withUserContextData(this.getUserContextData(userId));
        String ppEndpoint = this.getPinpointEndpointId();
        if (ppEndpoint != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(ppEndpoint);
            signUpUserRequest.setAnalyticsMetadata(amd);
        }
        return this.client.signUp(signUpUserRequest);
    }

    public CognitoUser getCurrentUser() {
        String csiLastUserKey = "CognitoIdentityProvider." + this.clientId + ".LastAuthUser";
        if (this.awsKeyValueStore.contains(csiLastUserKey)) {
            return this.getUser(this.awsKeyValueStore.get(csiLastUserKey));
        }
        return this.getUser();
    }

    public CognitoUser getUser() {
        return new CognitoUser(this, null, this.clientId, this.clientSecret, null, this.client, this.context);
    }

    public CognitoUser getUser(String userId) {
        if (userId == null) {
            return this.getUser();
        }
        if (userId.isEmpty()) {
            return this.getUser();
        }
        return new CognitoUser(this, userId, this.clientId, this.clientSecret, CognitoSecretHash.getSecretHash(userId, this.clientId, this.clientSecret), this.client, this.context);
    }

    protected String getPinpointEndpointId() {
        return this.pinpointEndpointId;
    }

    protected UserContextDataType getUserContextData(String userId) {
        UserContextDataType contextData = null;
        if (this.advancedSecurityDataCollectionFlag) {
            UserContextDataProvider provider = UserContextDataProvider.getInstance();
            String encodedData = provider.getEncodedContextData(this.context, userId, this.getUserPoolId(), this.clientId);
            contextData = new UserContextDataType();
            contextData.setEncodedData(encodedData);
        }
        return contextData;
    }
}

