/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class AdminCreateUserRequestMarshaller
implements Marshaller<Request<AdminCreateUserRequest>, AdminCreateUserRequest> {
    public Request<AdminCreateUserRequest> marshall(AdminCreateUserRequest adminCreateUserRequest) {
        if (adminCreateUserRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminCreateUserRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminCreateUserRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminCreateUser";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminCreateUserRequest.getUserPoolId() != null) {
                String userPoolId = adminCreateUserRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminCreateUserRequest.getUsername() != null) {
                String username = adminCreateUserRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (adminCreateUserRequest.getUserAttributes() != null) {
                List<AttributeType> userAttributes = adminCreateUserRequest.getUserAttributes();
                jsonWriter.name("UserAttributes");
                jsonWriter.beginArray();
                for (AttributeType attributeType : userAttributes) {
                    if (attributeType == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributeType, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (adminCreateUserRequest.getValidationData() != null) {
                List<AttributeType> validationData = adminCreateUserRequest.getValidationData();
                jsonWriter.name("ValidationData");
                jsonWriter.beginArray();
                for (AttributeType attributeType : validationData) {
                    if (attributeType == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributeType, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (adminCreateUserRequest.getTemporaryPassword() != null) {
                String temporaryPassword = adminCreateUserRequest.getTemporaryPassword();
                jsonWriter.name("TemporaryPassword");
                jsonWriter.value(temporaryPassword);
            }
            if (adminCreateUserRequest.getForceAliasCreation() != null) {
                Boolean forceAliasCreation = adminCreateUserRequest.getForceAliasCreation();
                jsonWriter.name("ForceAliasCreation");
                jsonWriter.value(forceAliasCreation.booleanValue());
            }
            if (adminCreateUserRequest.getMessageAction() != null) {
                String messageAction = adminCreateUserRequest.getMessageAction();
                jsonWriter.name("MessageAction");
                jsonWriter.value(messageAction);
            }
            if (adminCreateUserRequest.getDesiredDeliveryMediums() != null) {
                List<String> desiredDeliveryMediums = adminCreateUserRequest.getDesiredDeliveryMediums();
                jsonWriter.name("DesiredDeliveryMediums");
                jsonWriter.beginArray();
                for (String string : desiredDeliveryMediums) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (adminCreateUserRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = adminCreateUserRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry entry : clientMetadata.entrySet()) {
                    String clientMetadataValue = (String)entry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

