/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateDeviceStatusRequestMarshaller
implements Marshaller<Request<UpdateDeviceStatusRequest>, UpdateDeviceStatusRequest> {
    public Request<UpdateDeviceStatusRequest> marshall(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        if (updateDeviceStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateDeviceStatusRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDeviceStatusRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateDeviceStatus";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateDeviceStatusRequest.getAccessToken() != null) {
                String accessToken = updateDeviceStatusRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (updateDeviceStatusRequest.getDeviceKey() != null) {
                String deviceKey = updateDeviceStatusRequest.getDeviceKey();
                jsonWriter.name("DeviceKey");
                jsonWriter.value(deviceKey);
            }
            if (updateDeviceStatusRequest.getDeviceRememberedStatus() != null) {
                String deviceRememberedStatus = updateDeviceStatusRequest.getDeviceRememberedStatus();
                jsonWriter.name("DeviceRememberedStatus");
                jsonWriter.value(deviceRememberedStatus);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

