/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoServiceConstants;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthenticationDetails {
    private String authenticationType;
    private String userId;
    private String password;
    private List<AttributeType> validationData;
    private Map<String, String> authenticationParameters;

    public AuthenticationDetails(String userId, String password, Map<String, String> validationData) {
        this.authenticationType = CognitoServiceConstants.CHLG_TYPE_USER_PASSWORD_VERIFIER;
        this.userId = userId;
        this.password = password;
        this.setValidationData(validationData);
    }

    public AuthenticationDetails(String userId, Map<String, String> authenticationParameters, Map<String, String> validationData) {
        this.userId = userId;
        if (authenticationParameters != null) {
            this.authenticationType = CognitoServiceConstants.CHLG_TYPE_CUSTOM_CHALLENGE;
            this.authenticationParameters = authenticationParameters;
            this.setValidationData(validationData);
        } else {
            this.authenticationType = null;
        }
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        if (CognitoServiceConstants.CHLG_TYPE_USER_PASSWORD_VERIFIER.equals(this.authenticationType)) {
            this.authenticationParameters = null;
        } else if (CognitoServiceConstants.CHLG_TYPE_CUSTOM_CHALLENGE.equals(this.authenticationType)) {
            this.password = null;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<AttributeType> getValidationData() {
        return this.validationData;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public Map<String, String> getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public void setCustomChallenge(String customChallenge) {
        if (CognitoServiceConstants.CHLG_TYPE_USER_PASSWORD_VERIFIER.equals(this.authenticationType)) {
            throw new CognitoParameterInvalidException(String.format("Cannot set custom challenge when the authentication type is %s.", CognitoServiceConstants.CHLG_TYPE_USER_PASSWORD_VERIFIER));
        }
        this.authenticationType = CognitoServiceConstants.CHLG_TYPE_CUSTOM_CHALLENGE;
        this.setAuthenticationParameter(CognitoServiceConstants.AUTH_PARAM_CHALLENGE_NAME, customChallenge);
    }

    private void setValidationData(Map<String, String> validationData) {
        if (validationData != null) {
            this.validationData = new ArrayList<AttributeType>();
            for (Map.Entry<String, String> data : validationData.entrySet()) {
                AttributeType validation = new AttributeType();
                validation.setName(data.getKey());
                validation.setValue(data.getValue());
                this.validationData.add(validation);
            }
        } else {
            this.validationData = null;
        }
    }

    public void setAuthenticationParameters(Map<String, String> authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
    }

    public void setAuthenticationParameter(String key, String value) {
        if (key != null) {
            if (this.authenticationParameters == null) {
                this.authenticationParameters = new HashMap<String, String>();
            }
        } else {
            throw new CognitoParameterInvalidException("A null key was used to add a new authentications parameter.");
        }
        this.authenticationParameters.put(key, value);
    }
}

