/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.UserStatusType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UserType
implements Serializable {
    private String username;
    private List<AttributeType> attributes;
    private Date userCreateDate;
    private Date userLastModifiedDate;
    private Boolean enabled;
    private String userStatus;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserType withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<AttributeType> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<AttributeType>(attributes);
    }

    public UserType withAttributes(AttributeType ... attributes) {
        if (this.getAttributes() == null) {
            this.attributes = new ArrayList<AttributeType>(attributes.length);
        }
        for (AttributeType value : attributes) {
            this.attributes.add(value);
        }
        return this;
    }

    public UserType withAttributes(Collection<AttributeType> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Date getUserCreateDate() {
        return this.userCreateDate;
    }

    public void setUserCreateDate(Date userCreateDate) {
        this.userCreateDate = userCreateDate;
    }

    public UserType withUserCreateDate(Date userCreateDate) {
        this.userCreateDate = userCreateDate;
        return this;
    }

    public Date getUserLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public void setUserLastModifiedDate(Date userLastModifiedDate) {
        this.userLastModifiedDate = userLastModifiedDate;
    }

    public UserType withUserLastModifiedDate(Date userLastModifiedDate) {
        this.userLastModifiedDate = userLastModifiedDate;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UserType withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus;
    }

    public UserType withUserStatus(String userStatus) {
        this.userStatus = userStatus;
        return this;
    }

    public void setUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
    }

    public UserType withUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getUserCreateDate() != null) {
            sb.append("UserCreateDate: " + this.getUserCreateDate() + ",");
        }
        if (this.getUserLastModifiedDate() != null) {
            sb.append("UserLastModifiedDate: " + this.getUserLastModifiedDate() + ",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: " + this.getEnabled() + ",");
        }
        if (this.getUserStatus() != null) {
            sb.append("UserStatus: " + this.getUserStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserCreateDate() == null ? 0 : this.getUserCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getUserLastModifiedDate() == null ? 0 : this.getUserLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getUserStatus() == null ? 0 : this.getUserStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getUserCreateDate() == null ^ this.getUserCreateDate() == null) {
            return false;
        }
        if (other.getUserCreateDate() != null && !other.getUserCreateDate().equals(this.getUserCreateDate())) {
            return false;
        }
        if (other.getUserLastModifiedDate() == null ^ this.getUserLastModifiedDate() == null) {
            return false;
        }
        if (other.getUserLastModifiedDate() != null && !other.getUserLastModifiedDate().equals(this.getUserLastModifiedDate())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getUserStatus() == null ^ this.getUserStatus() == null) {
            return false;
        }
        return other.getUserStatus() == null || other.getUserStatus().equals(this.getUserStatus());
    }
}

