/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CognitoUserAttributes {
    private Map<String, String> userAttributes = new HashMap<String, String>();
    private Map<String, String> mfaOptions;

    public CognitoUserAttributes() {
        this(null);
    }

    protected CognitoUserAttributes(List<AttributeType> userAttributes) {
        if (userAttributes != null) {
            for (AttributeType attribute : userAttributes) {
                this.userAttributes.put(attribute.getName(), attribute.getValue());
            }
        }
    }

    public void addAttribute(String attributeName, String value) {
        this.userAttributes.put(attributeName, value);
    }

    public Map<String, String> getAttributes() {
        return this.userAttributes;
    }

    protected List<AttributeType> getAttributesList() {
        ArrayList<AttributeType> attributesList = new ArrayList<AttributeType>();
        if (this.userAttributes != null) {
            for (Map.Entry<String, String> detail : this.userAttributes.entrySet()) {
                AttributeType attribute = new AttributeType();
                attribute.setName(detail.getKey());
                attribute.setValue(detail.getValue());
                attributesList.add(attribute);
            }
        }
        return attributesList;
    }
}

