/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.EnhanceAuthRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class EnhanceAuthRequestMarshaller
implements Marshaller<Request<EnhanceAuthRequest>, EnhanceAuthRequest> {
    public Request<EnhanceAuthRequest> marshall(EnhanceAuthRequest enhanceAuthRequest) {
        if (enhanceAuthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(EnhanceAuthRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enhanceAuthRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.EnhanceAuth";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (enhanceAuthRequest.getClientId() != null) {
                String clientId = enhanceAuthRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (enhanceAuthRequest.getSecretHash() != null) {
                String secretHash = enhanceAuthRequest.getSecretHash();
                jsonWriter.name("SecretHash");
                jsonWriter.value(secretHash);
            }
            if (enhanceAuthRequest.getUsername() != null) {
                String username = enhanceAuthRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (enhanceAuthRequest.getAuthState() != null) {
                String authState = enhanceAuthRequest.getAuthState();
                jsonWriter.name("AuthState");
                jsonWriter.value(authState);
            }
            if (enhanceAuthRequest.getCode() != null) {
                String code = enhanceAuthRequest.getCode();
                jsonWriter.name("Code");
                jsonWriter.value(code);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

