/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.util;

import android.util.Base64;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class CognitoJWTParser {
    private static int HEADER = 0;
    private static int PAYLOAD = 1;
    private static int SIGNATURE = 2;

    public static JSONObject getHeader(String JWT) {
        try {
            CognitoJWTParser.validateJWT(JWT);
            byte[] sectionDecoded = Base64.decode((String)JWT.split("\\.")[HEADER], (int)8);
            return new JSONObject(new String(sectionDecoded, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (JSONException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static JSONObject getPayload(String JWT) {
        try {
            CognitoJWTParser.validateJWT(JWT);
            byte[] sectionDecoded = Base64.decode((String)JWT.split("\\.")[PAYLOAD], (int)8);
            return new JSONObject(new String(sectionDecoded, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (JSONException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static String getSignature(String JWT) {
        try {
            CognitoJWTParser.validateJWT(JWT);
            byte[] sectionDecoded = Base64.decode((String)JWT.split("\\.")[SIGNATURE], (int)8);
            return new String(sectionDecoded, "UTF-8");
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static String getClaim(String JWT, String claim) {
        try {
            JSONObject payload = CognitoJWTParser.getPayload(JWT);
            Object claimValue = payload.get(claim);
            if (claimValue != null) {
                return claimValue.toString();
            }
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("invalid token");
        }
        return null;
    }

    public static void validateJWT(String JWT) {
        String[] jwtParts = JWT.split("\\.");
        if (jwtParts.length != 3) {
            throw new CognitoParameterInvalidException("not a JSON Web Token");
        }
    }
}

