/*
 * Copyright 2013-2016 Amazon.com,
 * Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Amazon Software License (the "License").
 * You may not use this file except in compliance with the
 * License. A copy of the License is located at
 *
 *     http://aws.amazon.com/asl/
 *
 * or in the "license" file accompanying this file. This file is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, express or implied. See the License
 * for the specific language governing permissions and
 * limitations under the License.
 */

package com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions;

/**
 * This exception indicates that a code used for verification did not match with the excepted value.
 */
public class CognitoCodeMismatchException extends CognitoIdentityProviderException {
    private static final long serialVersionUID = -267743909862371391L;

    public CognitoCodeMismatchException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public CognitoCodeMismatchException(String message) {
        super(message);
    }
}
