/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import com.amazonaws.services.cognitoidentityprovider.model.UserStatusType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AdminGetUserResult
implements Serializable {
    private String username;
    private ListWithAutoConstructFlag<AttributeType> userAttributes;
    private Date userCreateDate;
    private Date userLastModifiedDate;
    private Boolean enabled;
    private String userStatus;
    private ListWithAutoConstructFlag<MFAOptionType> mFAOptions;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AdminGetUserResult withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        if (this.userAttributes == null) {
            this.userAttributes = new ListWithAutoConstructFlag();
            this.userAttributes.setAutoConstruct(true);
        }
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
        userAttributesCopy.addAll(userAttributes);
        this.userAttributes = userAttributesCopy;
    }

    public AdminGetUserResult withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType value : userAttributes) {
            this.getUserAttributes().add(value);
        }
        return this;
    }

    public AdminGetUserResult withUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
        } else {
            ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
            userAttributesCopy.addAll(userAttributes);
            this.userAttributes = userAttributesCopy;
        }
        return this;
    }

    public Date getUserCreateDate() {
        return this.userCreateDate;
    }

    public void setUserCreateDate(Date userCreateDate) {
        this.userCreateDate = userCreateDate;
    }

    public AdminGetUserResult withUserCreateDate(Date userCreateDate) {
        this.userCreateDate = userCreateDate;
        return this;
    }

    public Date getUserLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public void setUserLastModifiedDate(Date userLastModifiedDate) {
        this.userLastModifiedDate = userLastModifiedDate;
    }

    public AdminGetUserResult withUserLastModifiedDate(Date userLastModifiedDate) {
        this.userLastModifiedDate = userLastModifiedDate;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AdminGetUserResult withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus;
    }

    public AdminGetUserResult withUserStatus(String userStatus) {
        this.userStatus = userStatus;
        return this;
    }

    public void setUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
    }

    public AdminGetUserResult withUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        if (this.mFAOptions == null) {
            this.mFAOptions = new ListWithAutoConstructFlag();
            this.mFAOptions.setAutoConstruct(true);
        }
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        ListWithAutoConstructFlag mFAOptionsCopy = new ListWithAutoConstructFlag(mFAOptions.size());
        mFAOptionsCopy.addAll(mFAOptions);
        this.mFAOptions = mFAOptionsCopy;
    }

    public AdminGetUserResult withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.getMFAOptions() == null) {
            this.setMFAOptions(new ArrayList<MFAOptionType>(mFAOptions.length));
        }
        for (MFAOptionType value : mFAOptions) {
            this.getMFAOptions().add(value);
        }
        return this;
    }

    public AdminGetUserResult withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
        } else {
            ListWithAutoConstructFlag mFAOptionsCopy = new ListWithAutoConstructFlag(mFAOptions.size());
            mFAOptionsCopy.addAll(mFAOptions);
            this.mFAOptions = mFAOptionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getUserCreateDate() != null) {
            sb.append("UserCreateDate: " + this.getUserCreateDate() + ",");
        }
        if (this.getUserLastModifiedDate() != null) {
            sb.append("UserLastModifiedDate: " + this.getUserLastModifiedDate() + ",");
        }
        if (this.isEnabled() != null) {
            sb.append("Enabled: " + this.isEnabled() + ",");
        }
        if (this.getUserStatus() != null) {
            sb.append("UserStatus: " + this.getUserStatus() + ",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: " + this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserCreateDate() == null ? 0 : this.getUserCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getUserLastModifiedDate() == null ? 0 : this.getUserLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getUserStatus() == null ? 0 : this.getUserStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetUserResult)) {
            return false;
        }
        AdminGetUserResult other = (AdminGetUserResult)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getUserCreateDate() == null ^ this.getUserCreateDate() == null) {
            return false;
        }
        if (other.getUserCreateDate() != null && !other.getUserCreateDate().equals(this.getUserCreateDate())) {
            return false;
        }
        if (other.getUserLastModifiedDate() == null ^ this.getUserLastModifiedDate() == null) {
            return false;
        }
        if (other.getUserLastModifiedDate() != null && !other.getUserLastModifiedDate().equals(this.getUserLastModifiedDate())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.getUserStatus() == null ^ this.getUserStatus() == null) {
            return false;
        }
        if (other.getUserStatus() != null && !other.getUserStatus().equals(this.getUserStatus())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }
}

