/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.NumberAttributeConstraintsType;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.StringAttributeConstraintsType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AddCustomAttributesRequestMarshaller
implements Marshaller<Request<AddCustomAttributesRequest>, AddCustomAttributesRequest> {
    public Request<AddCustomAttributesRequest> marshall(AddCustomAttributesRequest addCustomAttributesRequest) {
        if (addCustomAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addCustomAttributesRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AddCustomAttributes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag customAttributesList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (addCustomAttributesRequest.getUserPoolId() != null) {
                jsonWriter.name("UserPoolId").value(addCustomAttributesRequest.getUserPoolId());
            }
            if (!((customAttributesList = (ListWithAutoConstructFlag)addCustomAttributesRequest.getCustomAttributes()) == null || customAttributesList.isAutoConstruct() && customAttributesList.isEmpty())) {
                jsonWriter.name("CustomAttributes");
                jsonWriter.beginArray();
                for (SchemaAttributeType customAttributesListValue : customAttributesList) {
                    StringAttributeConstraintsType stringAttributeConstraints;
                    NumberAttributeConstraintsType numberAttributeConstraints;
                    if (customAttributesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (customAttributesListValue.getName() != null) {
                        jsonWriter.name("Name").value(customAttributesListValue.getName());
                    }
                    if (customAttributesListValue.getAttributeDataType() != null) {
                        jsonWriter.name("AttributeDataType").value(customAttributesListValue.getAttributeDataType());
                    }
                    if (customAttributesListValue.isDeveloperOnlyAttribute() != null) {
                        jsonWriter.name("DeveloperOnlyAttribute").value(customAttributesListValue.isDeveloperOnlyAttribute().booleanValue());
                    }
                    if (customAttributesListValue.isMutable() != null) {
                        jsonWriter.name("Mutable").value(customAttributesListValue.isMutable().booleanValue());
                    }
                    if (customAttributesListValue.isRequired() != null) {
                        jsonWriter.name("Required").value(customAttributesListValue.isRequired().booleanValue());
                    }
                    if ((numberAttributeConstraints = customAttributesListValue.getNumberAttributeConstraints()) != null) {
                        jsonWriter.name("NumberAttributeConstraints");
                        jsonWriter.beginObject();
                        if (numberAttributeConstraints.getMinValue() != null) {
                            jsonWriter.name("MinValue").value(numberAttributeConstraints.getMinValue());
                        }
                        if (numberAttributeConstraints.getMaxValue() != null) {
                            jsonWriter.name("MaxValue").value(numberAttributeConstraints.getMaxValue());
                        }
                        jsonWriter.endObject();
                    }
                    if ((stringAttributeConstraints = customAttributesListValue.getStringAttributeConstraints()) != null) {
                        jsonWriter.name("StringAttributeConstraints");
                        jsonWriter.beginObject();
                        if (stringAttributeConstraints.getMinLength() != null) {
                            jsonWriter.name("MinLength").value(stringAttributeConstraints.getMinLength());
                        }
                        if (stringAttributeConstraints.getMaxLength() != null) {
                            jsonWriter.name("MaxLength").value(stringAttributeConstraints.getMaxLength());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

