/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.AuthEventType;
import com.amazonaws.services.cognitoidentityprovider.model.ChallengeResponseType;
import com.amazonaws.services.cognitoidentityprovider.model.EventContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.EventFeedbackType;
import com.amazonaws.services.cognitoidentityprovider.model.EventRiskType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ChallengeResponseTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EventContextDataTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EventFeedbackTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EventRiskTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class AuthEventTypeJsonMarshaller {
    private static AuthEventTypeJsonMarshaller instance;

    AuthEventTypeJsonMarshaller() {
    }

    public void marshall(AuthEventType authEventType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (authEventType.getEventId() != null) {
            String eventId = authEventType.getEventId();
            jsonWriter.name("EventId");
            jsonWriter.value(eventId);
        }
        if (authEventType.getEventType() != null) {
            String eventType = authEventType.getEventType();
            jsonWriter.name("EventType");
            jsonWriter.value(eventType);
        }
        if (authEventType.getCreationDate() != null) {
            Date creationDate = authEventType.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (authEventType.getEventResponse() != null) {
            String eventResponse = authEventType.getEventResponse();
            jsonWriter.name("EventResponse");
            jsonWriter.value(eventResponse);
        }
        if (authEventType.getEventRisk() != null) {
            EventRiskType eventRisk = authEventType.getEventRisk();
            jsonWriter.name("EventRisk");
            EventRiskTypeJsonMarshaller.getInstance().marshall(eventRisk, jsonWriter);
        }
        if (authEventType.getChallengeResponses() != null) {
            List<ChallengeResponseType> challengeResponses = authEventType.getChallengeResponses();
            jsonWriter.name("ChallengeResponses");
            jsonWriter.beginArray();
            for (ChallengeResponseType challengeResponsesItem : challengeResponses) {
                if (challengeResponsesItem == null) continue;
                ChallengeResponseTypeJsonMarshaller.getInstance().marshall(challengeResponsesItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (authEventType.getEventContextData() != null) {
            EventContextDataType eventContextData = authEventType.getEventContextData();
            jsonWriter.name("EventContextData");
            EventContextDataTypeJsonMarshaller.getInstance().marshall(eventContextData, jsonWriter);
        }
        if (authEventType.getEventFeedback() != null) {
            EventFeedbackType eventFeedback = authEventType.getEventFeedback();
            jsonWriter.name("EventFeedback");
            EventFeedbackTypeJsonMarshaller.getInstance().marshall(eventFeedback, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static AuthEventTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AuthEventTypeJsonMarshaller();
        }
        return instance;
    }
}

