/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.DefaultDataset;
import com.amazonaws.mobileconnectors.cognito.PushSyncUpdate;
import com.amazonaws.mobileconnectors.cognito.exceptions.RegistrationFailedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.UnsubscribeFailedException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.CognitoSyncStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.SQLiteLocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class CognitoSyncManager {
    private static final Log LOGGER = LogFactory.getLog(CognitoSyncManager.class);
    private static final String USER_AGENT = CognitoSyncManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String DATABASE_NAME = "cognito_dataset_cache.db";
    private static SQLiteLocalStorage local;
    private final Context context;
    private final CognitoSyncStorage remote;
    private final CognitoCachingCredentialsProvider provider;
    private final AmazonCognitoSyncClient syncClient;
    private final String identityPoolId;

    @Deprecated
    public CognitoSyncManager(Context context, String identityPoolId, Regions region, CognitoCachingCredentialsProvider provider) {
        this(context, region, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CognitoSyncManager(Context context, Regions region, CognitoCachingCredentialsProvider provider, AmazonCognitoSyncClient syncClient) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.context = context;
        this.provider = provider;
        this.identityPoolId = provider.getIdentityPoolId();
        Class<CognitoSyncManager> clazz = CognitoSyncManager.class;
        synchronized (CognitoSyncManager.class) {
            if (local == null) {
                local = new SQLiteLocalStorage(context, DATABASE_NAME);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.syncClient = syncClient;
            syncClient.setRegion(Region.getRegion((Regions)region));
            this.remote = new CognitoSyncStorage(this.identityPoolId, syncClient, provider);
            this.remote.setUserAgent(USER_AGENT);
            provider.registerIdentityChangedListener(new IdentityChangedListener(){

                public void identityChanged(String oldIdentityId, String newIdentityId) {
                    if (newIdentityId != null) {
                        LOGGER.info((Object)"identity change detected");
                        local.changeIdentityId(oldIdentityId == null ? "unknown" : oldIdentityId, newIdentityId);
                    }
                }
            });
            return;
        }
    }

    public CognitoSyncManager(Context context, CognitoCachingCredentialsProvider provider, AWSConfiguration awsConfig) {
        this(context, CognitoSyncManager.getRegionFromConfig(awsConfig), provider, CognitoSyncManager.getClientConfigFromConfig(awsConfig));
    }

    private static Regions getRegionFromConfig(AWSConfiguration awsConfig) {
        if (awsConfig != null) {
            try {
                JSONObject cognitoConfig = awsConfig.optJsonObject("Cognito");
                return Regions.fromName((String)cognitoConfig.getString("Region"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to read Cognito please check your setup or awsconfiguration.json file", e);
            }
        }
        throw new IllegalArgumentException("AWSConfiguration cannot be null");
    }

    private static ClientConfiguration getClientConfigFromConfig(AWSConfiguration awsConfig) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (awsConfig != null) {
            clientConfig.setUserAgent(awsConfig.getUserAgent());
        }
        return clientConfig;
    }

    public CognitoSyncManager(Context context, Regions region, CognitoCachingCredentialsProvider provider) {
        this(context, region, provider, new ClientConfiguration());
    }

    public CognitoSyncManager(Context context, Regions region, CognitoCachingCredentialsProvider provider, ClientConfiguration clientConfiguration) {
        this(context, region, provider, new AmazonCognitoSyncClient((AWSCredentialsProvider)provider, clientConfiguration));
    }

    public Dataset openOrCreateDataset(String datasetName) {
        DatasetUtils.validateDatasetName(datasetName);
        local.createDataset(this.getIdentityId(), datasetName);
        DefaultDataset dataset = new DefaultDataset(this.context, datasetName, this.provider, local, this.remote);
        return dataset;
    }

    public List<DatasetMetadata> listDatasets() {
        return local.getDatasets(this.getIdentityId());
    }

    public void refreshDatasetMetadata() {
        List<DatasetMetadata> datasets = this.remote.getDatasets();
        local.updateDatasetMetadata(this.getIdentityId(), datasets);
    }

    public void wipeData() {
        this.provider.clear();
        local.wipeData();
        LOGGER.info((Object)"All data has been wiped");
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }

    public void registerDevice(String platform, String token) {
        SharedPreferences sp = this.getSharedPreferences();
        if (this.isDeviceRegistered()) {
            LOGGER.info((Object)"Device is already registered");
            return;
        }
        String identityId = this.provider.getIdentityId();
        RegisterDeviceRequest request = new RegisterDeviceRequest().withIdentityPoolId(this.provider.getIdentityPoolId()).withIdentityId(identityId).withPlatform(platform).withToken(token);
        try {
            RegisterDeviceResult result = this.syncClient.registerDevice(request);
            sp.edit().putString(this.namespaceId("platform"), platform).apply();
            String deviceId = result.getDeviceId();
            sp.edit().putString(this.namespaceIdPlatform("deviceId"), deviceId).apply();
            LOGGER.info((Object)("Device is registered successfully: " + deviceId));
        }
        catch (AmazonClientException ace) {
            LOGGER.error((Object)"Failed to register device", (Throwable)ace);
            throw new RegistrationFailedException("Failed to register device", ace);
        }
    }

    public String getDeviceId() {
        return this.getSharedPreferences().getString(this.namespaceIdPlatform("deviceId"), "");
    }

    public boolean isDeviceRegistered() {
        if (this.provider.getCachedIdentityId() == null) {
            return false;
        }
        SharedPreferences sp = this.getSharedPreferences();
        return !sp.getString(this.namespaceIdPlatform("deviceId"), "").isEmpty() && !sp.getString(this.namespaceId("platform"), "").isEmpty();
    }

    public void unregisterDevice() {
        if (this.provider.getCachedIdentityId() != null) {
            SharedPreferences sp = this.getSharedPreferences();
            sp.edit().remove(this.namespaceIdPlatform("deviceId")).remove(this.namespaceId("platform")).apply();
        }
    }

    public void subscribeAll() {
        ArrayList<String> datasetNames = new ArrayList<String>();
        for (DatasetMetadata dataset : this.listDatasets()) {
            datasetNames.add(dataset.getDatasetName());
        }
        this.subscribe(datasetNames);
    }

    public void subscribe(List<String> datasetNames) {
        for (String datasetName : datasetNames) {
            Dataset dataset = this.openOrCreateDataset(datasetName);
            dataset.subscribe();
        }
    }

    public void unsubscribeAll() {
        ArrayList<String> datasetNames = new ArrayList<String>();
        for (DatasetMetadata dataset : this.listDatasets()) {
            datasetNames.add(dataset.getDatasetName());
        }
        this.unsubscribe(datasetNames);
    }

    public void unsubscribe(List<String> datasetNames) {
        for (String datasetName : datasetNames) {
            Dataset dataset = this.openOrCreateDataset(datasetName);
            try {
                dataset.unsubscribe();
            }
            catch (UnsubscribeFailedException ufe) {
                if (ufe.getCause() instanceof ResourceNotFoundException) {
                    LOGGER.warn((Object)("Unable to unsubscribe to dataset " + datasetName + ", dataset not a subscription"));
                    continue;
                }
                throw ufe;
            }
        }
    }

    public PushSyncUpdate getPushSyncUpdate(Intent intent) {
        return new PushSyncUpdate(intent);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("com.amazonaws.mobileconnectors.cognito", 0);
    }

    String namespaceIdPlatform(String key) {
        String platform = this.getSharedPreferences().getString(this.namespaceId("platform"), "");
        return this.namespaceId(platform) + "." + key;
    }

    String namespaceId(String key) {
        return this.provider.getCachedIdentityId() + "." + key;
    }

    void close() {
        local.close();
    }
}

