/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.transform.RecordPatchJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

@Deprecated
public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateRecordsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)updateRecordsRequest.getClientContext()));
        }
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", updateRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", updateRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getDatasetName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateRecordsRequest.getDeviceId() != null) {
                String deviceId = updateRecordsRequest.getDeviceId();
                jsonWriter.name("DeviceId");
                jsonWriter.value(deviceId);
            }
            if (updateRecordsRequest.getRecordPatches() != null) {
                List<RecordPatch> recordPatches = updateRecordsRequest.getRecordPatches();
                jsonWriter.name("RecordPatches");
                jsonWriter.beginArray();
                for (RecordPatch recordPatchesItem : recordPatches) {
                    if (recordPatchesItem == null) continue;
                    RecordPatchJsonMarshaller.getInstance().marshall(recordPatchesItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                String syncSessionToken = updateRecordsRequest.getSyncSessionToken();
                jsonWriter.name("SyncSessionToken");
                jsonWriter.value(syncSessionToken);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

