/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRecordsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolId;
    private String identityId;
    private String datasetName;
    private String deviceId;
    private ListWithAutoConstructFlag<RecordPatch> recordPatches;
    private String syncSessionToken;
    private String clientContext;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public UpdateRecordsRequest withIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
        return this;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public UpdateRecordsRequest withIdentityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public UpdateRecordsRequest withDatasetName(String datasetName) {
        this.datasetName = datasetName;
        return this;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public UpdateRecordsRequest withDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public List<RecordPatch> getRecordPatches() {
        if (this.recordPatches == null) {
            this.recordPatches = new ListWithAutoConstructFlag();
            this.recordPatches.setAutoConstruct(true);
        }
        return this.recordPatches;
    }

    public void setRecordPatches(Collection<RecordPatch> recordPatches) {
        if (recordPatches == null) {
            this.recordPatches = null;
            return;
        }
        ListWithAutoConstructFlag recordPatchesCopy = new ListWithAutoConstructFlag(recordPatches.size());
        recordPatchesCopy.addAll(recordPatches);
        this.recordPatches = recordPatchesCopy;
    }

    public UpdateRecordsRequest withRecordPatches(RecordPatch ... recordPatches) {
        if (this.getRecordPatches() == null) {
            this.setRecordPatches(new ArrayList<RecordPatch>(recordPatches.length));
        }
        for (RecordPatch value : recordPatches) {
            this.getRecordPatches().add(value);
        }
        return this;
    }

    public UpdateRecordsRequest withRecordPatches(Collection<RecordPatch> recordPatches) {
        if (recordPatches == null) {
            this.recordPatches = null;
        } else {
            ListWithAutoConstructFlag recordPatchesCopy = new ListWithAutoConstructFlag(recordPatches.size());
            recordPatchesCopy.addAll(recordPatches);
            this.recordPatches = recordPatchesCopy;
        }
        return this;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public void setSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
    }

    public UpdateRecordsRequest withSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
        return this;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    public UpdateRecordsRequest withClientContext(String clientContext) {
        this.clientContext = clientContext;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityId() != null) {
            sb.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: " + this.getDatasetName() + ",");
        }
        if (this.getDeviceId() != null) {
            sb.append("DeviceId: " + this.getDeviceId() + ",");
        }
        if (this.getRecordPatches() != null) {
            sb.append("RecordPatches: " + this.getRecordPatches() + ",");
        }
        if (this.getSyncSessionToken() != null) {
            sb.append("SyncSessionToken: " + this.getSyncSessionToken() + ",");
        }
        if (this.getClientContext() != null) {
            sb.append("ClientContext: " + this.getClientContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceId() == null ? 0 : this.getDeviceId().hashCode());
        hashCode = 31 * hashCode + (this.getRecordPatches() == null ? 0 : ((Object)this.getRecordPatches()).hashCode());
        hashCode = 31 * hashCode + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        hashCode = 31 * hashCode + (this.getClientContext() == null ? 0 : this.getClientContext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest other = (UpdateRecordsRequest)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (other.getIdentityId() != null && !other.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getDeviceId() == null ^ this.getDeviceId() == null) {
            return false;
        }
        if (other.getDeviceId() != null && !other.getDeviceId().equals(this.getDeviceId())) {
            return false;
        }
        if (other.getRecordPatches() == null ^ this.getRecordPatches() == null) {
            return false;
        }
        if (other.getRecordPatches() != null && !((Object)other.getRecordPatches()).equals(this.getRecordPatches())) {
            return false;
        }
        if (other.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        if (other.getSyncSessionToken() != null && !other.getSyncSessionToken().equals(this.getSyncSessionToken())) {
            return false;
        }
        if (other.getClientContext() == null ^ this.getClientContext() == null) {
            return false;
        }
        return other.getClientContext() == null || other.getClientContext().equals(this.getClientContext());
    }
}

