/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCognitoSyncAsyncClient
extends AmazonCognitoSyncClient
implements AmazonCognitoSyncAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCognitoSyncAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCognitoSyncAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials aWSCredentials, ExecutorService executorService) {
        super(aWSCredentials);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ExecutorService executorService) {
        this(aWSCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
            }
        });
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest, final AsyncHandler<UpdateRecordsRequest, UpdateRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                UpdateRecordsResult updateRecordsResult;
                try {
                    updateRecordsResult = AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateRecordsRequest, (Object)updateRecordsResult);
                return updateRecordsResult;
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest, final AsyncHandler<DescribeIdentityUsageRequest, DescribeIdentityUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                DescribeIdentityUsageResult describeIdentityUsageResult;
                try {
                    describeIdentityUsageResult = AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeIdentityUsageRequest, (Object)describeIdentityUsageResult);
                return describeIdentityUsageResult;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(final SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.setIdentityPoolConfiguration(setIdentityPoolConfigurationRequest);
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(final SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest, final AsyncHandler<SetIdentityPoolConfigurationRequest, SetIdentityPoolConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                SetIdentityPoolConfigurationResult setIdentityPoolConfigurationResult;
                try {
                    setIdentityPoolConfigurationResult = AmazonCognitoSyncAsyncClient.this.setIdentityPoolConfiguration(setIdentityPoolConfigurationRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setIdentityPoolConfigurationRequest, (Object)setIdentityPoolConfigurationResult);
                return setIdentityPoolConfigurationResult;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(final GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.getIdentityPoolConfiguration(getIdentityPoolConfigurationRequest);
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(final GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest, final AsyncHandler<GetIdentityPoolConfigurationRequest, GetIdentityPoolConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                GetIdentityPoolConfigurationResult getIdentityPoolConfigurationResult;
                try {
                    getIdentityPoolConfigurationResult = AmazonCognitoSyncAsyncClient.this.getIdentityPoolConfiguration(getIdentityPoolConfigurationRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getIdentityPoolConfigurationRequest, (Object)getIdentityPoolConfigurationResult);
                return getIdentityPoolConfigurationResult;
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(final UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.unsubscribeFromDataset(unsubscribeFromDatasetRequest);
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(final UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest, final AsyncHandler<UnsubscribeFromDatasetRequest, UnsubscribeFromDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                UnsubscribeFromDatasetResult unsubscribeFromDatasetResult;
                try {
                    unsubscribeFromDatasetResult = AmazonCognitoSyncAsyncClient.this.unsubscribeFromDataset(unsubscribeFromDatasetRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)unsubscribeFromDatasetRequest, (Object)unsubscribeFromDatasetResult);
                return unsubscribeFromDatasetResult;
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(final SubscribeToDatasetRequest subscribeToDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.subscribeToDataset(subscribeToDatasetRequest);
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(final SubscribeToDatasetRequest subscribeToDatasetRequest, final AsyncHandler<SubscribeToDatasetRequest, SubscribeToDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                SubscribeToDatasetResult subscribeToDatasetResult;
                try {
                    subscribeToDatasetResult = AmazonCognitoSyncAsyncClient.this.subscribeToDataset(subscribeToDatasetRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)subscribeToDatasetRequest, (Object)subscribeToDatasetResult);
                return subscribeToDatasetResult;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest, final AsyncHandler<DescribeIdentityPoolUsageRequest, DescribeIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                DescribeIdentityPoolUsageResult describeIdentityPoolUsageResult;
                try {
                    describeIdentityPoolUsageResult = AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeIdentityPoolUsageRequest, (Object)describeIdentityPoolUsageResult);
                return describeIdentityPoolUsageResult;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult listDatasetsResult;
                try {
                    listDatasetsResult = AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDatasetsRequest, (Object)listDatasetsResult);
                return listDatasetsResult;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest, final AsyncHandler<ListIdentityPoolUsageRequest, ListIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                ListIdentityPoolUsageResult listIdentityPoolUsageResult;
                try {
                    listIdentityPoolUsageResult = AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listIdentityPoolUsageRequest, (Object)listIdentityPoolUsageResult);
                return listIdentityPoolUsageResult;
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest, final AsyncHandler<ListRecordsRequest, ListRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                ListRecordsResult listRecordsResult;
                try {
                    listRecordsResult = AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listRecordsRequest, (Object)listRecordsResult);
                return listRecordsResult;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult describeDatasetResult;
                try {
                    describeDatasetResult = AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDatasetRequest, (Object)describeDatasetResult);
                return describeDatasetResult;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult deleteDatasetResult;
                try {
                    deleteDatasetResult = AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDatasetRequest, (Object)deleteDatasetResult);
                return deleteDatasetResult;
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(final RegisterDeviceRequest registerDeviceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.registerDevice(registerDeviceRequest);
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(final RegisterDeviceRequest registerDeviceRequest, final AsyncHandler<RegisterDeviceRequest, RegisterDeviceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                RegisterDeviceResult registerDeviceResult;
                try {
                    registerDeviceResult = AmazonCognitoSyncAsyncClient.this.registerDevice(registerDeviceRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerDeviceRequest, (Object)registerDeviceResult);
                return registerDeviceResult;
            }
        });
    }
}

