/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito.internal.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.LocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLiteLocalStorage
implements LocalStorage {
    private static final String TAG = "SQLiteLocalStorage";
    static final String TABLE_DATASETS = "datasets";
    static final String TABLE_RECORDS = "records";
    final DatabaseHelper helper;

    public SQLiteLocalStorage(Context context, String string) {
        this.helper = new DatabaseHelper(context, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataset(String string, String string2) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            DatasetMetadata datasetMetadata = this.getMetadataInternal(sQLiteDatabase, string, string2);
            if (datasetMetadata == null) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("identity_id", string);
                contentValues.put("dataset_name", string2);
                contentValues.put("creation_timestamp", String.valueOf(new Date().getTime()));
                contentValues.put("last_modified_timestamp", String.valueOf(new Date().getTime()));
                long l = sQLiteDatabase.insert(TABLE_DATASETS, null, contentValues);
                if (l == -1L) {
                    Log.e((String)TAG, (String)String.format("couldn't create dataset %s", string2));
                }
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public String getValue(String string, String string2, String string3) {
        Record record = this.getRecord(string, string2, string3);
        if (record == null) {
            return null;
        }
        return record.getValue();
    }

    @Override
    public void putValue(String string, String string2, String string3, String string4) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        boolean bl = this.putValueInternal(sQLiteDatabase, string, string2, string3, string4);
        if (!bl) {
            Log.e((String)TAG, (String)String.format("failed to put record [%s: %s] into dataset %s", string3, string4, string2));
        } else {
            this.updateLastModifiedTimestamp(sQLiteDatabase, string, string2);
        }
    }

    @Override
    public Map<String, String> getValueMap(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<Record> list = this.getRecords(string, string2);
        for (Record record : list) {
            if (record.isDeleted()) continue;
            hashMap.put(record.getKey(), record.getValue());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllValues(String string, String string2, Map<String, String> map) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.putValueInternal(sQLiteDatabase, string, string2, entry.getKey(), entry.getValue());
            }
            this.updateLastModifiedTimestamp(sQLiteDatabase, string, string2);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    boolean putValueInternal(SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String string4) {
        Record record = this.getRecord(string, string2, string3);
        if (record != null && StringUtils.equals(record.getValue(), string4)) {
            return true;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("identity_id", string);
        contentValues.put("dataset_name", string2);
        contentValues.put("key", string3);
        contentValues.put("value", string4);
        contentValues.put("modified", Boolean.valueOf(true));
        contentValues.put("sync_count", Long.valueOf(record == null ? 0L : record.getSyncCount()));
        contentValues.put("device_last_modified_timestamp", String.valueOf(new Date().getTime()));
        if (record == null) {
            return sQLiteDatabase.insert(TABLE_RECORDS, null, contentValues) != -1L;
        }
        return sQLiteDatabase.update(TABLE_RECORDS, contentValues, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{string, string2, string3}) == 1;
    }

    @Override
    public List<DatasetMetadata> getDatasets(String string) {
        ArrayList<DatasetMetadata> arrayList = new ArrayList<DatasetMetadata>();
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ?", new String[]{string}, null, null, null);
        while (cursor.moveToNext()) {
            arrayList.add(this.cursorToDatasetMetadata(cursor));
        }
        cursor.close();
        return arrayList;
    }

    @Override
    public DatasetMetadata getDatasetMetadata(String string, String string2) throws DataStorageException {
        DatasetMetadata datasetMetadata = null;
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{string, string2}, null, null, null);
        if (cursor.moveToFirst()) {
            datasetMetadata = this.cursorToDatasetMetadata(cursor);
        }
        cursor.close();
        return datasetMetadata;
    }

    DatasetMetadata cursorToDatasetMetadata(Cursor cursor) {
        String string = cursor.getString(cursor.getColumnIndex("dataset_name"));
        return new DatasetMetadata.Builder(string).creationDate(new Date(cursor.getLong(cursor.getColumnIndex("creation_timestamp")))).lastModifiedDate(new Date(cursor.getLong(cursor.getColumnIndex("last_modified_timestamp")))).lastModifiedBy(cursor.getString(cursor.getColumnIndex("last_modified_by"))).storageSizeBytes(cursor.getLong(cursor.getColumnIndex("storage_size_bytes"))).recordCount(cursor.getLong(cursor.getColumnIndex("record_count"))).build();
    }

    @Override
    public Record getRecord(String string, String string2, String string3) {
        Record record = null;
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{string, string2, string3}, null, null, null);
        if (cursor.moveToFirst()) {
            record = this.cursorToRecord(cursor);
        }
        cursor.close();
        return record;
    }

    @Override
    public List<Record> getRecords(String string, String string2) {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{string, string2}, null, null, null);
        while (cursor.moveToNext()) {
            arrayList.add(this.cursorToRecord(cursor));
        }
        cursor.close();
        return arrayList;
    }

    Record cursorToRecord(Cursor cursor) {
        return new Record.Builder(cursor.getString(cursor.getColumnIndex("key"))).value(cursor.getString(cursor.getColumnIndex("value"))).syncCount(cursor.getLong(cursor.getColumnIndex("sync_count"))).deviceLastModifiedDate(new Date(cursor.getLong(cursor.getColumnIndex("device_last_modified_timestamp")))).lastModifiedDate(new Date(cursor.getLong(cursor.getColumnIndex("last_modified_timestamp")))).lastModifiedBy(cursor.getString(cursor.getColumnIndex("last_modified_by"))).modified(cursor.getInt(cursor.getColumnIndex("modified")) == 1).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putRecords(String string, String string2, List<Record> list) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            for (Record record : list) {
                this.updateAndClearRecord(sQLiteDatabase, string, string2, record);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(String string, String string2) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n = sQLiteDatabase.delete(TABLE_RECORDS, "identity_id = ? AND dataset_name = ?", new String[]{string, string2});
            Log.i((String)TAG, (String)String.format("%d records were deleted from dataset %s", n, string2));
            ContentValues contentValues = new ContentValues();
            contentValues.put("last_modified_timestamp", Long.valueOf(System.currentTimeMillis()));
            contentValues.put("last_sync_count", String.valueOf(-1));
            n = sQLiteDatabase.update(TABLE_DATASETS, contentValues, "identity_id = ? AND dataset_name = ?", new String[]{string, string2});
            if (n != 1) {
                Log.e((String)TAG, (String)String.format("couldn't mark dataset %s deleted", string2));
            } else {
                sQLiteDatabase.setTransactionSuccessful();
            }
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @Override
    public void purgeDataset(String string, String string2) {
        this.deleteDataset(string, string2);
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        int n = sQLiteDatabase.delete(TABLE_DATASETS, "identity_id = ? AND dataset_name = ?", new String[]{string, string2});
        if (n != 1) {
            Log.e((String)TAG, (String)String.format("failed to purge dataset %s", string2));
        }
    }

    @Override
    public long getLastSyncCount(String string, String string2) {
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{string, string2}, null, null, null);
        if (cursor.moveToFirst()) {
            l = cursor.getInt(cursor.getColumnIndex("last_sync_count"));
        } else {
            Log.w((String)TAG, (String)String.format("couldn't find %s in %s table", string2, TABLE_DATASETS));
        }
        cursor.close();
        return l;
    }

    @Override
    public List<Record> getModifiedRecords(String string, String string2) {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        Cursor cursor = sQLiteDatabase.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ? AND modified = ?", new String[]{string, string2, String.valueOf(1)}, null, null, null);
        while (cursor.moveToNext()) {
            arrayList.add(this.cursorToRecord(cursor));
        }
        cursor.close();
        return arrayList;
    }

    public void close() {
        this.helper.close();
    }

    @Override
    public void updateLastSyncCount(String string, String string2, long l) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("last_sync_count", Long.valueOf(l));
        contentValues.put("last_sync_timestamp", Long.valueOf(System.currentTimeMillis()));
        int n = sQLiteDatabase.update(TABLE_DATASETS, contentValues, "identity_id = ? AND dataset_name = ?", new String[]{string, string2});
        if (n != 1) {
            Log.e((String)TAG, (String)String.format("failed to update last sync count of dataset %s", string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData() {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            sQLiteDatabase.execSQL("DELETE FROM datasets");
            sQLiteDatabase.execSQL("DELETE FROM records");
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    void updateLastModifiedTimestamp(SQLiteDatabase sQLiteDatabase, String string, String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("last_modified_timestamp", Long.valueOf(System.currentTimeMillis()));
        int n = sQLiteDatabase.update(TABLE_DATASETS, contentValues, "identity_id = ? AND dataset_name = ?", new String[]{string, string2});
        if (n != 1) {
            Log.w((String)TAG, (String)String.format("failed to update last modified timestamp of dataset %s", string2));
        }
    }

    void removeRecord(SQLiteDatabase sQLiteDatabase, String string, String string2, Record record) {
        int n = sQLiteDatabase.delete(TABLE_RECORDS, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{string, string2, record.getKey()});
        if (n == 0) {
            Log.w((String)TAG, (String)String.format("failed to delete record %s from dataset %s", record.getKey(), string2));
        }
    }

    void updateAndClearRecord(SQLiteDatabase sQLiteDatabase, String string, String string2, Record record) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("identity_id", string);
        contentValues.put("dataset_name", string2);
        contentValues.put("key", record.getKey());
        contentValues.put("value", record.getValue());
        contentValues.put("sync_count", Long.valueOf(record.getSyncCount()));
        contentValues.put("modified", Boolean.valueOf(false));
        long l = sQLiteDatabase.replace(TABLE_RECORDS, null, contentValues);
        if (l == -1L) {
            Log.e((String)TAG, (String)String.format("failed to store record [%s: %s] into dataset %s", record.getKey(), record.getValue(), string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void changeIdentityId(String string, String string2) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            if ("unknown".equals(string)) {
                sQLiteDatabase.execSQL("UPDATE datasets SET identity_id = '" + string2 + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
                sQLiteDatabase.execSQL("UPDATE records SET identity_id = '" + string2 + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
            } else {
                sQLiteDatabase.execSQL("INSERT INTO datasets(identity_id,dataset_name,creation_timestamp,storage_size_bytes,record_count) SELECT '" + string2 + "'," + "dataset_name" + "," + "creation_timestamp" + "," + "storage_size_bytes" + "," + "record_count" + " FROM " + TABLE_DATASETS + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
                sQLiteDatabase.execSQL("INSERT INTO records(identity_id,dataset_name,key,value,last_modified_timestamp,last_modified_by,device_last_modified_timestamp) SELECT '" + string2 + "'," + "dataset_name" + "," + "key" + "," + "value" + "," + "last_modified_timestamp" + "," + "last_modified_by" + "," + "device_last_modified_timestamp" + " FROM " + TABLE_RECORDS + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
                sQLiteDatabase.execSQL("UPDATE datasets SET identity_id = '" + string2 + "', " + "dataset_name" + " = " + "dataset_name" + " || '." + string + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
                sQLiteDatabase.execSQL("UPDATE records SET identity_id = '" + string2 + "', " + "dataset_name" + " = " + "dataset_name" + " || '." + string + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{string});
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatasetMetadata(String string, List<DatasetMetadata> list) {
        SQLiteDatabase sQLiteDatabase = this.helper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            for (DatasetMetadata datasetMetadata : list) {
                if (this.updateDatasetMetadataInternal(sQLiteDatabase, string, datasetMetadata)) continue;
                Log.w((String)TAG, (String)String.format("couldn't update dataset metadata %s", datasetMetadata.getDatasetName()));
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    DatasetMetadata getMetadataInternal(SQLiteDatabase sQLiteDatabase, String string, String string2) {
        DatasetMetadata datasetMetadata = null;
        Cursor cursor = sQLiteDatabase.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{string, string2}, null, null, null);
        if (cursor.moveToFirst()) {
            datasetMetadata = this.cursorToDatasetMetadata(cursor);
        }
        cursor.close();
        return datasetMetadata;
    }

    boolean updateDatasetMetadataInternal(SQLiteDatabase sQLiteDatabase, String string, DatasetMetadata datasetMetadata) {
        DatasetMetadata datasetMetadata2 = this.getMetadataInternal(sQLiteDatabase, string, datasetMetadata.getDatasetName());
        ContentValues contentValues = new ContentValues();
        contentValues.put("identity_id", string);
        contentValues.put("dataset_name", datasetMetadata.getDatasetName());
        contentValues.put("creation_timestamp", Long.valueOf(datasetMetadata.getCreationDate().getTime()));
        contentValues.put("last_modified_timestamp", Long.valueOf(datasetMetadata.getLastModifiedDate().getTime()));
        contentValues.put("last_modified_by", datasetMetadata.getLastModifiedBy());
        contentValues.put("record_count", Long.valueOf(datasetMetadata.getRecordCount()));
        contentValues.put("storage_size_bytes", Long.valueOf(datasetMetadata.getStorageSizeBytes()));
        if (datasetMetadata2 == null) {
            return sQLiteDatabase.insert(TABLE_DATASETS, null, contentValues) != -1L;
        }
        return sQLiteDatabase.update(TABLE_DATASETS, contentValues, "identity_id = ? AND dataset_name = ?", new String[]{string, datasetMetadata.getDatasetName()}) == 1;
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final int DB_VERSION = 2;

        public DatabaseHelper(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE datasets(identity_id TEXT NOT NULL,dataset_name TEXT NOT NULL,creation_timestamp INTEGER DEFAULT 0,last_modified_timestamp INTEGER DEFAULT 0,last_modified_by TEXT,storage_size_bytes INTEGER DEFAULT 0,record_count INTEGER DEFAULT 0,last_sync_count INTEGER NOT NULL DEFAULT 0,last_sync_timestamp INTEGER DEFAULT 0,last_sync_result TEXT,UNIQUE (identity_id, dataset_name))");
            sQLiteDatabase.execSQL("CREATE TABLE records(identity_id TEXT NOT NULL,dataset_name TEXT NOT NULL,key TEXT NOT NULL,value TEXT,sync_count INTEGER NOT NULL DEFAULT 0,last_modified_timestamp INTEGER DEFAULT 0,last_modified_by TEXT,device_last_modified_timestamp INTEGER DEFAULT 0,modified INTEGER NOT NULL DEFAULT 1,UNIQUE (identity_id, dataset_name, key))");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.w((String)SQLiteLocalStorage.TAG, (String)"Upgrading database; wiping all data");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS datasets");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS records");
            this.onCreate(sQLiteDatabase);
        }
    }

    static class RecordColumns {
        static final String IDENTITY_ID = "identity_id";
        static final String DATASET_NAME = "dataset_name";
        static final String KEY = "key";
        static final String VALUE = "value";
        static final String SYNC_COUNT = "sync_count";
        static final String LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
        static final String LAST_MODIFIED_BY = "last_modified_by";
        static final String DEVICE_LAST_MODIFIED_TIMESTAMP = "device_last_modified_timestamp";
        static final String MODIFIED = "modified";
        static final String[] ALL = new String[]{"identity_id", "dataset_name", "key", "value", "sync_count", "last_modified_timestamp", "last_modified_by", "device_last_modified_timestamp", "modified"};

        RecordColumns() {
        }
    }

    static class DatasetColumns {
        static final String IDENTITY_ID = "identity_id";
        static final String DATASET_NAME = "dataset_name";
        static final String CREATION_TIMESTAMP = "creation_timestamp";
        static final String LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
        static final String LAST_MODIFIED_BY = "last_modified_by";
        static final String STORAGE_SIZE_BYTES = "storage_size_bytes";
        static final String RECORD_COUNT = "record_count";
        static final String LAST_SYNC_COUNT = "last_sync_count";
        static final String LAST_SYNC_TIMESTAMP = "last_sync_timestamp";
        static final String LAST_SYNC_RESULT = "last_sync_result";
        static final String[] ALL = new String[]{"identity_id", "dataset_name", "creation_timestamp", "last_modified_timestamp", "last_modified_by", "storage_size_bytes", "record_count", "last_sync_count", "last_sync_timestamp", "last_sync_result"};

        DatasetColumns() {
        }
    }
}

