/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InvalidConfigurationExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;

public class AmazonCognitoSyncClient
extends AmazonWebServiceClient
implements AmazonCognitoSync {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCognitoSync.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonCognitoSyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCognitoSyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceConflictExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NotAuthorizedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidConfigurationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cognito-sync.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cognitosync/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cognitosync/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecordsResult updateRecords(UpdateRecordsRequest updateRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecordsRequestMarshaller().marshall(updateRecordsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateRecordsResultJsonUnmarshaller unmarshaller = new UpdateRecordsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateRecordsResult updateRecordsResult = (UpdateRecordsResult)response.getAwsResponse();
            return updateRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityUsageResult describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityUsageRequestMarshaller().marshall(describeIdentityUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeIdentityUsageResultJsonUnmarshaller unmarshaller = new DescribeIdentityUsageResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeIdentityUsageResult describeIdentityUsageResult = (DescribeIdentityUsageResult)response.getAwsResponse();
            return describeIdentityUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityPoolConfigurationResult setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityPoolConfigurationRequestMarshaller().marshall(setIdentityPoolConfigurationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SetIdentityPoolConfigurationResultJsonUnmarshaller unmarshaller = new SetIdentityPoolConfigurationResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SetIdentityPoolConfigurationResult setIdentityPoolConfigurationResult = (SetIdentityPoolConfigurationResult)response.getAwsResponse();
            return setIdentityPoolConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoolConfigurationResult getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityPoolConfigurationRequestMarshaller().marshall(getIdentityPoolConfigurationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetIdentityPoolConfigurationResultJsonUnmarshaller unmarshaller = new GetIdentityPoolConfigurationResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetIdentityPoolConfigurationResult getIdentityPoolConfigurationResult = (GetIdentityPoolConfigurationResult)response.getAwsResponse();
            return getIdentityPoolConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeFromDatasetResult unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeFromDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeFromDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeFromDatasetRequestMarshaller().marshall(unsubscribeFromDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UnsubscribeFromDatasetResultJsonUnmarshaller unmarshaller = new UnsubscribeFromDatasetResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UnsubscribeFromDatasetResult unsubscribeFromDatasetResult = (UnsubscribeFromDatasetResult)response.getAwsResponse();
            return unsubscribeFromDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeToDatasetResult subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeToDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeToDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeToDatasetRequestMarshaller().marshall(subscribeToDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SubscribeToDatasetResultJsonUnmarshaller unmarshaller = new SubscribeToDatasetResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SubscribeToDatasetResult subscribeToDatasetResult = (SubscribeToDatasetResult)response.getAwsResponse();
            return subscribeToDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolUsageResult describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityPoolUsageRequestMarshaller().marshall(describeIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeIdentityPoolUsageResultJsonUnmarshaller unmarshaller = new DescribeIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeIdentityPoolUsageResult describeIdentityPoolUsageResult = (DescribeIdentityPoolUsageResult)response.getAwsResponse();
            return describeIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestMarshaller().marshall(listDatasetsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListDatasetsResultJsonUnmarshaller unmarshaller = new ListDatasetsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolUsageResult listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityPoolUsageRequestMarshaller().marshall(listIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListIdentityPoolUsageResultJsonUnmarshaller unmarshaller = new ListIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListIdentityPoolUsageResult listIdentityPoolUsageResult = (ListIdentityPoolUsageResult)response.getAwsResponse();
            return listIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult listRecords(ListRecordsRequest listRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordsRequestMarshaller().marshall(listRecordsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListRecordsResultJsonUnmarshaller unmarshaller = new ListRecordsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRecordsResult listRecordsResult = (ListRecordsResult)response.getAwsResponse();
            return listRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestMarshaller().marshall(describeDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDatasetResultJsonUnmarshaller unmarshaller = new DescribeDatasetResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestMarshaller().marshall(deleteDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteDatasetResultJsonUnmarshaller unmarshaller = new DeleteDatasetResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDeviceResult registerDevice(RegisterDeviceRequest registerDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDeviceRequestMarshaller().marshall(registerDeviceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RegisterDeviceResultJsonUnmarshaller unmarshaller = new RegisterDeviceResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RegisterDeviceResult registerDeviceResult = (RegisterDeviceResult)response.getAwsResponse();
            return registerDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

