/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.amazonaws.mobile.auth.core.signin.SignInManager;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.auth.userpools.FormView;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.UserPoolFormConstants;

public class UserPoolSignInView
extends LinearLayout {
    private static final String LOG_TAG = UserPoolSignInView.class.getSimpleName();
    private TextView signUpTextView;
    private TextView forgotPasswordTextView;
    private FormView credentialsFormView;
    private EditText userNameEditText;
    private EditText passwordEditText;
    private Button signInButton;
    private boolean isInitialized;
    private int backgroundColor;
    private static final int DEFAULT_BACKGROUND_COLOR = -12303292;
    private String fontFamily;
    private boolean isBackgroundColorFullScreenEnabled;

    public UserPoolSignInView(Context context) {
        this(context, null);
    }

    public UserPoolSignInView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UserPoolSignInView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.setGravity(17);
        this.setId(R.id.user_pool_sign_in_view_id);
        this.setupCredentialsForm(context);
        this.setupSignInButton(context);
        this.setupLayoutForSignUpAndForgotPassword(context);
        this.setupFontFamily((Activity)context);
        this.setupBackgroundColor((Activity)context);
        this.setupBackgroundColorFullScreen((Activity)context);
    }

    private void initializeIfNecessary() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (this.isInEditMode()) {
            return;
        }
        try {
            SignInManager signInManager = SignInManager.getInstance();
            signInManager.initializeSignInButton(CognitoUserPoolsSignInProvider.class, (View)this.signInButton);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Cannot initialize the SignInButton. Please check if IdentityManager : startUpAuth and setUpToAuthenticate are invoked", (Throwable)exception);
        }
    }

    private void setupCredentialsForm(Context context) {
        this.credentialsFormView = new FormView(context);
        LinearLayout.LayoutParams formViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.userNameEditText = this.credentialsFormView.addFormField(context, 33, context.getString(R.string.sign_in_username));
        this.passwordEditText = this.credentialsFormView.addFormField(context, 129, context.getString(R.string.sign_in_password));
        this.addView((View)this.credentialsFormView, (ViewGroup.LayoutParams)formViewLayoutParams);
    }

    private void setupSignInButton(Context context) {
        this.signInButton = new Button(context);
        this.signInButton.setTextColor(-1);
        this.signInButton.setText((CharSequence)context.getString(R.string.sign_in_button_text));
        this.signInButton.setAllCaps(false);
        this.signInButton.setBackgroundDrawable((Drawable)DisplayUtils.getRoundedRectangleBackground((int)UserPoolFormConstants.FORM_BUTTON_CORNER_RADIUS, (int)-12215809));
        Resources resources = this.getResources();
        LinearLayout.LayoutParams signInButtonLayoutParams = new LinearLayout.LayoutParams(-1, resources.getDimensionPixelSize(R.dimen.sign_in_button_height));
        int signInButtonMarginTopBottom = resources.getDimensionPixelSize(R.dimen.user_pools_sign_in_button_margin_top_bottom);
        signInButtonLayoutParams.setMargins(this.credentialsFormView.getFormShadowMargin(), signInButtonMarginTopBottom + this.credentialsFormView.getFormShadowMargin(), this.credentialsFormView.getFormShadowMargin(), 0);
        this.addView((View)this.signInButton, (ViewGroup.LayoutParams)signInButtonLayoutParams);
    }

    private void setupLayoutForSignUpAndForgotPassword(Context context) {
        LinearLayout layoutForSignUpAndForgotPassword = new LinearLayout(context);
        layoutForSignUpAndForgotPassword.setOrientation(0);
        LinearLayout.LayoutParams layoutParamsForSignUpAndForgotPassword = new LinearLayout.LayoutParams(-1, -2);
        layoutParamsForSignUpAndForgotPassword.setMargins(this.credentialsFormView.getFormShadowMargin(), DisplayUtils.dp((int)10), this.credentialsFormView.getFormShadowMargin(), 0);
        layoutParamsForSignUpAndForgotPassword.gravity = 1;
        this.signUpTextView = new TextView(context);
        this.signUpTextView.setText(R.string.sign_in_new_account);
        this.signUpTextView.setTextAppearance(context, 16973894);
        this.signUpTextView.setGravity(0x800003);
        this.signUpTextView.setTextColor(-12215809);
        LinearLayout.LayoutParams layoutParamsForNewAccountText = new LinearLayout.LayoutParams(-2, -2);
        layoutParamsForNewAccountText.weight = 1.0f;
        layoutForSignUpAndForgotPassword.addView((View)this.signUpTextView, (ViewGroup.LayoutParams)layoutParamsForNewAccountText);
        this.forgotPasswordTextView = new TextView(context);
        this.forgotPasswordTextView.setText(R.string.sign_in_forgot_password);
        this.forgotPasswordTextView.setTextAppearance(context, 16973894);
        this.forgotPasswordTextView.setGravity(0x800005);
        this.forgotPasswordTextView.setTextColor(-12215809);
        LinearLayout.LayoutParams layoutParamsForForgotPassword = new LinearLayout.LayoutParams(-2, -2);
        layoutParamsForForgotPassword.weight = 1.0f;
        layoutForSignUpAndForgotPassword.addView((View)this.forgotPasswordTextView, (ViewGroup.LayoutParams)layoutParamsForForgotPassword);
        this.addView((View)layoutForSignUpAndForgotPassword, (ViewGroup.LayoutParams)layoutParamsForSignUpAndForgotPassword);
    }

    private void setupBackgroundColor(Activity activity) {
        Intent intent = activity.getIntent();
        this.backgroundColor = intent.getIntExtra("signInBackgroundColor", -12303292);
    }

    int getBackgroundColor() {
        return this.backgroundColor;
    }

    String getFontFamily() {
        return this.fontFamily;
    }

    boolean isBackgroundColorFullScreen() {
        return this.isBackgroundColorFullScreenEnabled;
    }

    private void setupFontFamily(Activity activity) {
        Intent intent = activity.getIntent();
        this.fontFamily = intent.getStringExtra("fontFamily");
        if (this.fontFamily != null) {
            Typeface typeFace = Typeface.create((String)this.fontFamily, (int)0);
            Log.d((String)LOG_TAG, (String)("Setup font in UserPoolSignInView: " + this.fontFamily));
            this.signUpTextView.setTypeface(typeFace);
            this.forgotPasswordTextView.setTypeface(typeFace);
            this.signInButton.setTypeface(typeFace);
            this.userNameEditText.setTypeface(typeFace);
            this.passwordEditText.setTypeface(typeFace);
        }
    }

    private void setupBackgroundColorFullScreen(Activity activity) {
        Intent intent = activity.getIntent();
        this.isBackgroundColorFullScreenEnabled = intent.getBooleanExtra("fullScreenBackgroundColor", false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxWidth = Math.min((int)((double)parentWidth * 0.85), UserPoolFormConstants.MAX_FORM_WIDTH_IN_PIXELS);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
        this.initializeIfNecessary();
    }

    public TextView getSignUpTextView() {
        return this.signUpTextView;
    }

    public TextView getForgotPasswordTextView() {
        return this.forgotPasswordTextView;
    }

    public String getEnteredUserName() {
        return this.userNameEditText.getText().toString();
    }

    public String getEnteredPassword() {
        return this.passwordEditText.getText().toString();
    }

    public FormView getCredentialsFormView() {
        return this.credentialsFormView;
    }
}

