/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.amazonaws.mobile.auth.core.signin.ui.BackgroundDrawable;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.SplitBackgroundDrawable;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.auth.userpools.FormView;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.UserPoolFormConstants;

public class SignUpConfirmView
extends LinearLayout {
    private static final String LOG_TAG = SignUpConfirmView.class.getSimpleName();
    private FormView confirmForm;
    private EditText userNameEditText;
    private EditText confirmCodeEditText;
    private Button confirmButton;
    private SplitBackgroundDrawable splitBackgroundDrawable;
    private BackgroundDrawable backgroundDrawable;
    private String fontFamily;
    private boolean fullScreenBackgroundColor;
    private Typeface typeFace;
    private int backgroundColor;

    public SignUpConfirmView(Context context) {
        this(context, null);
    }

    public SignUpConfirmView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignUpConfirmView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        if (this.isInEditMode()) {
            int backgroundColor = -12303292;
        } else {
            TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.SignUpConfirmView);
            int backgroundColor = styledAttributes.getInt(R.styleable.SignUpConfirmView_signUpConfirmViewBackgroundColor, -12303292);
            styledAttributes.recycle();
        }
        this.fontFamily = CognitoUserPoolsSignInProvider.getFontFamily();
        this.typeFace = Typeface.create((String)this.fontFamily, (int)0);
        this.fullScreenBackgroundColor = CognitoUserPoolsSignInProvider.isBackgroundColorFullScreen();
        this.backgroundColor = CognitoUserPoolsSignInProvider.getBackgroundColor();
        if (this.fullScreenBackgroundColor) {
            this.backgroundDrawable = new BackgroundDrawable(this.backgroundColor);
        } else {
            this.splitBackgroundDrawable = new SplitBackgroundDrawable(0, this.backgroundColor);
        }
    }

    private void setupFontFamily() {
        if (this.typeFace != null) {
            Log.d((String)LOG_TAG, (String)("Setup font in SignUpConfirmView: " + this.fontFamily));
            this.userNameEditText.setTypeface(this.typeFace);
            this.confirmCodeEditText.setTypeface(this.typeFace);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.confirmForm = (FormView)this.findViewById(R.id.signup_confirm_form);
        this.userNameEditText = this.confirmForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.username_text));
        this.confirmCodeEditText = this.confirmForm.addFormField(this.getContext(), 2, this.getContext().getString(R.string.sign_up_confirm_code));
        this.setupConfirmButtonColor();
        this.setupFontFamily();
    }

    private void setupConfirmButtonColor() {
        this.confirmButton = (Button)this.findViewById(R.id.confirm_account_button);
        this.confirmButton.setBackgroundDrawable((Drawable)DisplayUtils.getRoundedRectangleBackground((int)UserPoolFormConstants.FORM_BUTTON_CORNER_RADIUS, (int)-12215809));
        LinearLayout.LayoutParams signUpButtonLayoutParams = (LinearLayout.LayoutParams)this.confirmButton.getLayoutParams();
        signUpButtonLayoutParams.setMargins(this.confirmForm.getFormShadowMargin(), signUpButtonLayoutParams.topMargin, this.confirmForm.getFormShadowMargin(), signUpButtonLayoutParams.bottomMargin);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxWidth = Math.min((int)((double)parentWidth * 0.85), UserPoolFormConstants.MAX_FORM_WIDTH_IN_PIXELS);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.setupBackground();
    }

    private void setupBackground() {
        if (!this.fullScreenBackgroundColor) {
            this.splitBackgroundDrawable.setSplitPointDistanceFromTop(this.confirmForm.getTop() + this.confirmForm.getMeasuredHeight() / 2);
            ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.splitBackgroundDrawable);
        } else {
            ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.backgroundDrawable);
        }
    }

    public EditText getUserNameEditText() {
        return this.userNameEditText;
    }

    public EditText getConfirmCodeEditText() {
        return this.confirmCodeEditText;
    }
}

