/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.userpools.FormEditText;

public class FormView
extends LinearLayout {
    private static final int FORM_CORNER_RADIUS = DisplayUtils.dp((int)8);
    private static final int FIELD_LEFT_RIGHT_MARGIN = DisplayUtils.dp((int)20);
    private final Drawable[] backgroundDrawables;

    public FormView(Context context) {
        this(context, null);
    }

    public FormView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FormView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean isDarkModeOn = (context.getResources().getConfiguration().uiMode & 0x30) == 32;
        this.backgroundDrawables = new Drawable[]{this.createRoundedRectShape(FORM_CORNER_RADIUS, -12303292, 10), this.createRoundedRectShape(FORM_CORNER_RADIUS, -12303292, 20), this.createRoundedRectShape(FORM_CORNER_RADIUS, -12303292, 30), this.createRoundedRectShape(FORM_CORNER_RADIUS, -12303292, 50), this.createRoundedRectShape(FORM_CORNER_RADIUS, -12303292, 80), this.createRoundedRectShape(FORM_CORNER_RADIUS, isDarkModeOn ? -16777216 : -1, 100)};
        this.setOrientation(1);
        this.setBackgroundDrawable(this.getFormBackground());
    }

    private ShapeDrawable createRoundedRectShape(int cornerRadius, int color, int alpha) {
        ShapeDrawable insetBorderDrawable = DisplayUtils.getRoundedRectangleBackground((int)cornerRadius, (int)color);
        if (alpha < 100) {
            insetBorderDrawable.setAlpha(alpha);
        }
        insetBorderDrawable.getPaint().setColor(color);
        return insetBorderDrawable;
    }

    private Drawable getFormBackground() {
        LayerDrawable layerDrawable = new LayerDrawable(this.backgroundDrawables);
        for (int i = 0; i < this.backgroundDrawables.length; ++i) {
            layerDrawable.setLayerInset(i, DisplayUtils.dp((int)i), DisplayUtils.dp((int)i), DisplayUtils.dp((int)i), DisplayUtils.dp((int)i));
        }
        return layerDrawable;
    }

    private EditText addField(Context context, int inputType, String fieldName) {
        int additionalTopMarginForFirstElement;
        if (this.getChildCount() == 0) {
            additionalTopMarginForFirstElement = this.getFormShadowMargin();
        } else {
            additionalTopMarginForFirstElement = 0;
            LinearLayout.LayoutParams prevFormEditTextLayoutParams = (LinearLayout.LayoutParams)this.getChildAt(this.getChildCount() - 1).getLayoutParams();
            prevFormEditTextLayoutParams.setMargins(prevFormEditTextLayoutParams.leftMargin, prevFormEditTextLayoutParams.topMargin, prevFormEditTextLayoutParams.rightMargin, 0);
            this.addView(new Divider(context), -1, DisplayUtils.dp((int)1));
        }
        FormEditText formEditText = new FormEditText(context, inputType, fieldName);
        LinearLayout.LayoutParams formEditTextLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        formEditTextLayoutParams.setMargins(FIELD_LEFT_RIGHT_MARGIN, additionalTopMarginForFirstElement, FIELD_LEFT_RIGHT_MARGIN, this.getFormShadowMargin());
        this.addView((View)formEditText, (ViewGroup.LayoutParams)formEditTextLayoutParams);
        return formEditText.getEditTextView();
    }

    public EditText addFormField(Context context, int inputType, String fieldName) {
        return this.addField(context, inputType, fieldName);
    }

    public int getFormShadowMargin() {
        return DisplayUtils.dp((int)(this.backgroundDrawables.length - 1));
    }

    private static class Divider
    extends View {
        final Paint paint = new Paint();

        public Divider(Context context) {
            super(context);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.paint.setColor(-3355444);
            canvas.drawRect((float)this.getMeasuredWidth() * 0.1f, 0.0f, (float)this.getMeasuredWidth() * 0.9f, (float)this.getMeasuredHeight(), this.paint);
        }
    }
}

