/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.IdRes;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.userpools.R;
import java.util.Locale;

public class FormEditText
extends LinearLayout {
    private static final int TEXT_VIEW_ID = 3841;
    private static final int EDIT_TEXT_ID = 3842;
    private static final int BIT_FOR_SHOWING_PASSWORD = 16;
    private static final int TEXT_VIEW_TOP_MARGIN = DisplayUtils.dp((int)5);
    private static final int EDIT_VIEW_BOTTOM_PADDING = DisplayUtils.dp((int)5);
    private static final int SHOW_PASSWORD_LEFT_RIGHT_MARGIN = DisplayUtils.dp((int)5);
    private static final int SHOW_PASSWORD_TOP_MARGIN = DisplayUtils.dp((int)-5);
    private TextView textView;
    private EditText editText;
    private LinearLayout editFieldLayout;
    private TextView showPasswordToggleTextView = null;
    private boolean hasSetMinimumSize = false;

    @IdRes
    private int toViewId(int id2) {
        return id2;
    }

    public FormEditText(Context context, int inputType, String fieldName) {
        super(context);
        this.setOrientation(1);
        this.setGravity(16);
        this.textView = new TextView(context);
        this.textView.setText((CharSequence)fieldName.toUpperCase(Locale.getDefault()));
        this.textView.setId(this.toViewId(3841));
        LinearLayout.LayoutParams textViewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        textViewLayoutParams.setMargins(0, TEXT_VIEW_TOP_MARGIN, 0, 0);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)textViewLayoutParams);
        this.textView.setVisibility(4);
        this.editText = new EditText(context);
        this.editText.setSingleLine();
        this.editText.setInputType(inputType);
        this.editText.setBackgroundColor(0);
        this.editText.setPadding(0, DisplayUtils.dp((int)2), 0, DisplayUtils.dp((int)2) + EDIT_VIEW_BOTTOM_PADDING);
        this.editText.setId(this.toViewId(3842));
        this.editText.setHint((CharSequence)fieldName);
        LinearLayout.LayoutParams editTextLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        editTextLayoutParams.setMargins(0, 0, 0, 0);
        if ((inputType & 0x80) > 0) {
            this.editFieldLayout = new LinearLayout(context);
            this.editFieldLayout.setOrientation(0);
            editTextLayoutParams.gravity = 0x800003;
            editTextLayoutParams.weight = 1.0f;
            this.editFieldLayout.addView((View)this.editText, (ViewGroup.LayoutParams)editTextLayoutParams);
            this.showPasswordToggleTextView = new TextView(context);
            this.setupShowHidePassword();
            this.addView((View)this.editFieldLayout);
        } else {
            this.addView((View)this.editText, (ViewGroup.LayoutParams)editTextLayoutParams);
        }
        this.setupTextChangedListener();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.hasSetMinimumSize) {
            this.setMinimumHeight(this.textView.getMeasuredHeight() + TEXT_VIEW_TOP_MARGIN + this.editText.getMeasuredHeight());
            this.textView.setVisibility(8);
            this.hasSetMinimumSize = true;
        }
    }

    private void setupShowHidePassword() {
        final String showText = this.getResources().getString(R.string.sign_in_show_password);
        final String hideText = this.getResources().getString(R.string.sign_in_hide_password);
        this.showPasswordToggleTextView.setText((CharSequence)showText);
        LinearLayout.LayoutParams showPassLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        showPassLayoutParams.setMargins(SHOW_PASSWORD_LEFT_RIGHT_MARGIN, SHOW_PASSWORD_TOP_MARGIN, SHOW_PASSWORD_LEFT_RIGHT_MARGIN, 0);
        showPassLayoutParams.gravity = 8388629;
        this.editFieldLayout.addView((View)this.showPasswordToggleTextView, (ViewGroup.LayoutParams)showPassLayoutParams);
        this.showPasswordToggleTextView.setVisibility(8);
        this.showPasswordToggleTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CharSequence oldText = FormEditText.this.showPasswordToggleTextView.getText();
                String newText = oldText.equals(showText) ? hideText : showText;
                FormEditText.this.showPasswordToggleTextView.setText((CharSequence)newText);
                int selectionStart = FormEditText.this.editText.getSelectionStart();
                int selectionEnd = FormEditText.this.editText.getSelectionEnd();
                if (oldText.equals(showText)) {
                    FormEditText.this.editText.setInputType(FormEditText.this.editText.getInputType() | 0x10);
                } else {
                    FormEditText.this.editText.setInputType(FormEditText.this.editText.getInputType() & 0xFFFFFFEF);
                }
                FormEditText.this.editText.setSelection(selectionStart, selectionEnd);
            }
        });
    }

    private void setupTextChangedListener() {
        this.editText.addTextChangedListener(new TextWatcher(){

            private void handleFloatingTextVisibility() {
                if (FormEditText.this.editText.getText().length() == 0) {
                    if (FormEditText.this.hasSetMinimumSize) {
                        FormEditText.this.textView.setVisibility(8);
                    }
                    FormEditText.this.editText.setPadding(0, DisplayUtils.dp((int)2), 0, DisplayUtils.dp((int)2) + EDIT_VIEW_BOTTOM_PADDING);
                    if (FormEditText.this.showPasswordToggleTextView != null) {
                        FormEditText.this.showPasswordToggleTextView.setVisibility(8);
                    }
                } else {
                    FormEditText.this.textView.setVisibility(0);
                    FormEditText.this.editText.setPadding(0, DisplayUtils.dp((int)1), 0, DisplayUtils.dp((int)3) + EDIT_VIEW_BOTTOM_PADDING);
                    if (FormEditText.this.showPasswordToggleTextView != null) {
                        FormEditText.this.showPasswordToggleTextView.setVisibility(0);
                    }
                }
            }

            public void beforeTextChanged(CharSequence text, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence text, int start, int before, int count) {
            }

            public void afterTextChanged(Editable text) {
                this.handleFloatingTextVisibility();
            }
        });
    }

    public EditText getEditTextView() {
        return this.editText;
    }
}

