/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobile.auth.core.IdentityHandler;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.SignInResultHandler;
import com.amazonaws.mobile.auth.core.SignInStateChangeListener;
import com.amazonaws.mobile.auth.core.StartupAuthErrorDetails;
import com.amazonaws.mobile.auth.core.StartupAuthResult;
import com.amazonaws.mobile.auth.core.StartupAuthResultHandler;
import com.amazonaws.mobile.auth.core.internal.util.ThreadUtils;
import com.amazonaws.mobile.auth.core.signin.AuthException;
import com.amazonaws.mobile.auth.core.signin.CognitoAuthException;
import com.amazonaws.mobile.auth.core.signin.ProviderAuthException;
import com.amazonaws.mobile.auth.core.signin.SignInManager;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IdentityManager {
    private static final String LOG_TAG = IdentityManager.class.getSimpleName();
    private static final String AWS_CONFIGURATION_FILE = "awsconfiguration.json";
    private final AWSCredentialsProviderHolder credentialsProviderHolder;
    private final Context appContext;
    private AWSConfiguration awsConfiguration;
    private final ClientConfiguration clientConfiguration;
    private final ExecutorService executorService = Executors.newFixedThreadPool(4);
    private final CountDownLatch startupAuthTimeoutLatch = new CountDownLatch(1);
    private final List<Class<? extends SignInProvider>> signInProviderClasses = new LinkedList<Class<? extends SignInProvider>>();
    private volatile IdentityProvider currentIdentityProvider = null;
    private SignInProviderResultAdapter resultsAdapter;
    private final HashSet<SignInStateChangeListener> signInStateChangeListeners = new HashSet();
    private static IdentityManager defaultIdentityManager = null;
    private static final String SHARED_PREF_NAME = "com.amazonaws.android.auth";
    private static final String EXPIRATION_KEY = "expirationDate";

    public IdentityManager(Context context) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = null;
        this.clientConfiguration = null;
        this.credentialsProviderHolder = null;
    }

    public IdentityManager(Context context, AWSConfiguration awsConfiguration) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = awsConfiguration;
        this.clientConfiguration = new ClientConfiguration().withUserAgent(awsConfiguration.getUserAgent());
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.initializeCognito(this.appContext, this.clientConfiguration);
    }

    public IdentityManager(Context context, AWSConfiguration awsConfiguration, ClientConfiguration clientConfiguration) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = awsConfiguration;
        this.clientConfiguration = clientConfiguration;
        String userAgent = this.awsConfiguration.getUserAgent();
        String currentUserAgent = this.clientConfiguration.getUserAgent();
        String string2 = currentUserAgent = currentUserAgent != null ? currentUserAgent : "";
        if (userAgent != null && userAgent != currentUserAgent) {
            this.clientConfiguration.setUserAgent(currentUserAgent.trim() + " " + userAgent);
        }
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.initializeCognito(this.appContext, this.clientConfiguration);
    }

    public IdentityManager(Context context, CognitoCachingCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.appContext = context.getApplicationContext();
        this.clientConfiguration = clientConfiguration;
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.setCredentialsProvider(context, credentialsProvider);
    }

    public static IdentityManager getDefaultIdentityManager() {
        return defaultIdentityManager;
    }

    public static void setDefaultIdentityManager(IdentityManager identityManager) {
        defaultIdentityManager = null;
        defaultIdentityManager = identityManager;
    }

    public AWSConfiguration getConfiguration() {
        return this.awsConfiguration;
    }

    public void setConfiguration(AWSConfiguration configuration) {
        this.awsConfiguration = configuration;
    }

    public boolean areCredentialsExpired() {
        Date credentialsExpirationDate = this.credentialsProviderHolder.getUnderlyingProvider().getSessionCredentitalsExpiration();
        if (credentialsExpirationDate == null) {
            Log.d((String)LOG_TAG, (String)"Credentials are EXPIRED.");
            return true;
        }
        long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
        boolean credsAreExpired = credentialsExpirationDate.getTime() - currentTime < 0L;
        Log.d((String)LOG_TAG, (String)("Credentials are " + (credsAreExpired ? "EXPIRED." : "OK")));
        return credsAreExpired;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProviderHolder;
    }

    public CognitoCachingCredentialsProvider getUnderlyingProvider() {
        return this.credentialsProviderHolder.getUnderlyingProvider();
    }

    public String getCachedUserID() {
        return this.credentialsProviderHolder.getUnderlyingProvider().getCachedIdentityId();
    }

    public void getUserID(final IdentityHandler handler) {
        this.executorService.submit(new Runnable(){
            Exception exception = null;

            @Override
            public void run() {
                String result;
                String identityId = null;
                try {
                    result = identityId = IdentityManager.this.credentialsProviderHolder.getUnderlyingProvider().getIdentityId();
                }
                catch (Exception exception) {
                    String result2;
                    try {
                        this.exception = exception;
                        Log.e((String)LOG_TAG, (String)exception.getMessage(), (Throwable)exception);
                        result2 = identityId;
                    }
                    catch (Throwable throwable) {
                        String result3 = identityId;
                        Log.d((String)LOG_TAG, (String)("Got user ID: " + identityId));
                        if (handler != null) {
                            ThreadUtils.runOnUiThread(new Runnable(result3){
                                final /* synthetic */ String val$result;
                                {
                                    this.val$result = string2;
                                }

                                @Override
                                public void run() {
                                    if (exception != null) {
                                        handler.handleError(exception);
                                        return;
                                    }
                                    handler.onIdentityId(this.val$result);
                                }
                            });
                        }
                        throw throwable;
                    }
                    Log.d((String)LOG_TAG, (String)("Got user ID: " + identityId));
                    if (handler != null) {
                        ThreadUtils.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                Log.d((String)LOG_TAG, (String)("Got user ID: " + identityId));
                if (handler != null) {
                    ThreadUtils.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignInStateChangeListener(SignInStateChangeListener listener) {
        HashSet<SignInStateChangeListener> hashSet = this.signInStateChangeListeners;
        synchronized (hashSet) {
            this.signInStateChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSignInStateChangeListener(SignInStateChangeListener listener) {
        HashSet<SignInStateChangeListener> hashSet = this.signInStateChangeListeners;
        synchronized (hashSet) {
            this.signInStateChangeListeners.remove(listener);
        }
    }

    public SignInProviderResultAdapter getResultsAdapter() {
        return this.resultsAdapter;
    }

    public void signOut() {
        Log.d((String)LOG_TAG, (String)"Signing out...");
        if (this.currentIdentityProvider != null) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IdentityManager.this.currentIdentityProvider.signOut();
                    IdentityManager.this.credentialsProviderHolder.getUnderlyingProvider().clear();
                    IdentityManager.this.currentIdentityProvider = null;
                    HashSet hashSet = IdentityManager.this.signInStateChangeListeners;
                    synchronized (hashSet) {
                        for (SignInStateChangeListener listener : IdentityManager.this.signInStateChangeListeners) {
                            listener.onUserSignedOut();
                        }
                    }
                }
            });
        }
    }

    private void refreshCredentialWithLogins(Map<String, String> loginMap) {
        CognitoCachingCredentialsProvider credentialsProvider = this.credentialsProviderHolder.getUnderlyingProvider();
        credentialsProvider.clear();
        credentialsProvider.withLogins(loginMap);
        Log.d((String)LOG_TAG, (String)"refresh credentials");
        credentialsProvider.refresh();
        this.appContext.getSharedPreferences(SHARED_PREF_NAME, 0).edit().putLong(credentialsProvider.getIdentityPoolId() + "." + EXPIRATION_KEY, System.currentTimeMillis() + 510000L).commit();
    }

    public void setProviderResultsHandler(SignInProviderResultHandler signInProviderResultHandler) {
        if (signInProviderResultHandler == null) {
            throw new IllegalArgumentException("signInProviderResultHandler cannot be null.");
        }
        this.resultsAdapter = new SignInProviderResultAdapter(signInProviderResultHandler);
    }

    public void federateWithProvider(IdentityProvider provider) {
        Log.d((String)LOG_TAG, (String)"federateWithProvider");
        final HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put(provider.getCognitoLoginKey(), provider.getToken());
        this.currentIdentityProvider = provider;
        this.initializeCognito(this.appContext, this.clientConfiguration);
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IdentityManager.this.refreshCredentialWithLogins(loginMap);
                }
                catch (Exception ex) {
                    IdentityManager.this.resultsAdapter.onCognitoError(ex);
                    return;
                }
                IdentityManager.this.resultsAdapter.onCognitoSuccess();
                HashSet hashSet = IdentityManager.this.signInStateChangeListeners;
                synchronized (hashSet) {
                    for (SignInStateChangeListener listener : IdentityManager.this.signInStateChangeListeners) {
                        listener.onUserSignedIn();
                    }
                }
            }
        });
    }

    public IdentityProvider getCurrentIdentityProvider() {
        return this.currentIdentityProvider;
    }

    public void addSignInProvider(Class<? extends SignInProvider> providerClass) {
        this.signInProviderClasses.add(providerClass);
    }

    public Collection<Class<? extends SignInProvider>> getSignInProviderClasses() {
        return this.signInProviderClasses;
    }

    public boolean isUserSignedIn() {
        Map logins = this.credentialsProviderHolder.getUnderlyingProvider().getLogins();
        return logins != null && logins.size() != 0;
    }

    private void handleStartupAuthResult(Activity callingActivity, final StartupAuthResultHandler startupAuthResultHandler, final AuthException authException, final Exception unAuthException) {
        this.runAfterStartupAuthDelay(callingActivity, new Runnable(){

            @Override
            public void run() {
                startupAuthResultHandler.onComplete(new StartupAuthResult(IdentityManager.this, new StartupAuthErrorDetails(authException, unAuthException)));
            }
        });
    }

    private void handleUnauthenticated(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler, AuthException ex) {
        SignInManager.dispose();
        this.handleStartupAuthResult(callingActivity, startupAuthResultHandler, ex, null);
    }

    private void runAfterStartupAuthDelay(final Activity callingActivity, final Runnable runnable) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    IdentityManager.this.startupAuthTimeoutLatch.await();
                }
                catch (InterruptedException e) {
                    Log.d((String)LOG_TAG, (String)"Interrupted while waiting for startup auth minimum delay.");
                }
                callingActivity.runOnUiThread(runnable);
            }
        });
    }

    public void resumeSession(final Activity callingActivity, final StartupAuthResultHandler startupAuthResultHandler, final long minimumDelay) {
        Log.d((String)LOG_TAG, (String)"Resume session called.");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Log.d((String)LOG_TAG, (String)"Starting up authentication...");
                SignInManager signInManager = SignInManager.getInstance(callingActivity.getApplicationContext());
                if (signInManager == null) {
                    throw new IllegalStateException("You cannot pass null for identityManager.");
                }
                SignInProvider provider = signInManager.getPreviouslySignedInProvider();
                if (provider != null) {
                    Log.d((String)LOG_TAG, (String)("Refreshing credentials with identity provider " + provider.getDisplayName()));
                    signInManager.refreshCredentialsWithProvider(callingActivity, provider, new SignInProviderResultHandler(){

                        @Override
                        public void onSuccess(IdentityProvider provider) {
                            SignInManager.dispose();
                            Log.d((String)LOG_TAG, (String)("Successfully got credentials from identity provider '" + provider.getDisplayName()));
                            IdentityManager.this.runAfterStartupAuthDelay(callingActivity, new Runnable(){

                                @Override
                                public void run() {
                                    startupAuthResultHandler.onComplete(new StartupAuthResult(IdentityManager.this, null));
                                }
                            });
                        }

                        @Override
                        public void onCancel(IdentityProvider provider) {
                            Log.wtf((String)LOG_TAG, (String)"Cancel can't happen when handling a previously signed-in user.");
                        }

                        @Override
                        public void onError(IdentityProvider provider, Exception ex) {
                            Log.e((String)LOG_TAG, (String)String.format("Cognito credentials refresh with %s provider failed. Error: %s", provider.getDisplayName(), ex.getMessage()), (Throwable)ex);
                            if (ex instanceof AuthException) {
                                IdentityManager.this.handleUnauthenticated(callingActivity, startupAuthResultHandler, (AuthException)ex);
                            } else {
                                IdentityManager.this.handleUnauthenticated(callingActivity, startupAuthResultHandler, new AuthException(provider, ex));
                            }
                        }
                    });
                } else {
                    IdentityManager.this.handleUnauthenticated(callingActivity, startupAuthResultHandler, null);
                }
                if (minimumDelay > 0L) {
                    try {
                        Thread.sleep(minimumDelay);
                    }
                    catch (InterruptedException ex) {
                        Log.i((String)LOG_TAG, (String)"Interrupted while waiting for startup auth timeout.");
                    }
                }
                IdentityManager.this.startupAuthTimeoutLatch.countDown();
            }
        });
    }

    public void resumeSession(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        this.resumeSession(callingActivity, startupAuthResultHandler, 0L);
    }

    @Deprecated
    public void doStartupAuth(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        this.resumeSession(callingActivity, startupAuthResultHandler, 0L);
    }

    @Deprecated
    public void doStartupAuth(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler, long minimumDelay) {
        this.resumeSession(callingActivity, startupAuthResultHandler, minimumDelay);
    }

    public void expireSignInTimeout() {
        this.startupAuthTimeoutLatch.countDown();
    }

    @Deprecated
    public void setUpToAuthenticate(Context context, SignInResultHandler signInResultHandler) {
        this.login(context, signInResultHandler);
    }

    public void login(Context context, SignInResultHandler signInResultHandler) {
        try {
            SignInManager.getInstance(context.getApplicationContext()).setResultHandler(signInResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Error in instantiating SignInManager. Check the context and completion handler.", (Throwable)exception);
        }
    }

    private void setCredentialsProvider(Context context, CognitoCachingCredentialsProvider cachingCredentialsProvider) {
        this.credentialsProviderHolder.setUnderlyingProvider(cachingCredentialsProvider);
    }

    private void initializeCognito(Context context, ClientConfiguration clientConfiguration) {
        Log.d((String)LOG_TAG, (String)"Initializing Cognito");
        String region = this.getCognitoIdentityRegion();
        Regions cognitoIdentityRegion = Regions.fromName((String)region);
        this.setCredentialsProvider(context, new CognitoCachingCredentialsProvider(context, this.getCognitoIdentityPoolId(), cognitoIdentityRegion, clientConfiguration));
        AWSRefreshingCognitoIdentityProvider refreshingCredentialsProvider = new AWSRefreshingCognitoIdentityProvider(null, this.getCognitoIdentityPoolId(), clientConfiguration, cognitoIdentityRegion);
        this.setCredentialsProvider(context, new CognitoCachingCredentialsProvider(context, (AWSCognitoIdentityProvider)refreshingCredentialsProvider, cognitoIdentityRegion, clientConfiguration));
    }

    private String getCognitoIdentityPoolId() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CredentialsProvider").getJSONObject("CognitoIdentity").getJSONObject(this.awsConfiguration.getConfiguration()).getString("PoolId");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot access Cognito IdentityPoolId from the awsconfiguration.json file.", exception);
        }
    }

    private String getCognitoIdentityRegion() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CredentialsProvider").getJSONObject("CognitoIdentity").getJSONObject(this.awsConfiguration.getConfiguration()).getString("Region");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find the Cognito Region from the awsconfiguration.json file.", exception);
        }
    }

    private class SignInProviderResultAdapter
    implements SignInProviderResultHandler {
        private final SignInProviderResultHandler handler;

        private SignInProviderResultAdapter(SignInProviderResultHandler handler) {
            this.handler = handler;
        }

        @Override
        public void onSuccess(IdentityProvider provider) {
            Log.d((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onSuccess(): %s provider sign-in succeeded.", provider.getDisplayName()));
            IdentityManager.this.federateWithProvider(provider);
        }

        private void onCognitoSuccess() {
            Log.d((String)LOG_TAG, (String)"SignInProviderResultAdapter.onCognitoSuccess()");
            this.handler.onSuccess(IdentityManager.this.currentIdentityProvider);
        }

        private void onCognitoError(Exception ex) {
            Log.d((String)LOG_TAG, (String)"SignInProviderResultAdapter.onCognitoError()", (Throwable)ex);
            IdentityProvider provider = IdentityManager.this.currentIdentityProvider;
            IdentityManager.this.signOut();
            this.handler.onError(provider, new CognitoAuthException(provider, ex));
        }

        @Override
        public void onCancel(IdentityProvider provider) {
            Log.d((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onCancel(): %s provider sign-in canceled.", provider.getDisplayName()));
            this.handler.onCancel(provider);
        }

        @Override
        public void onError(IdentityProvider provider, Exception ex) {
            Log.e((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onError(): %s provider error. %s", provider.getDisplayName(), ex.getMessage()), (Throwable)ex);
            this.handler.onError(provider, new ProviderAuthException(provider, ex));
        }
    }

    private class AWSRefreshingCognitoIdentityProvider
    extends AWSBasicCognitoIdentityProvider {
        private final String LOG_TAG;

        public AWSRefreshingCognitoIdentityProvider(String accountId, String identityPoolId, ClientConfiguration clientConfiguration, Regions regions) {
            super(accountId, identityPoolId, clientConfiguration);
            this.LOG_TAG = AWSRefreshingCognitoIdentityProvider.class.getSimpleName();
            this.cib.setRegion(Region.getRegion((Regions)regions));
        }

        public String refresh() {
            Log.d((String)this.LOG_TAG, (String)"Refreshing token...");
            if (IdentityManager.this.currentIdentityProvider != null) {
                String newToken = IdentityManager.this.currentIdentityProvider.refreshToken();
                this.getLogins().put(IdentityManager.this.currentIdentityProvider.getCognitoLoginKey(), newToken);
            }
            return super.refresh();
        }
    }

    private class AWSCredentialsProviderHolder
    implements AWSCredentialsProvider {
        private volatile CognitoCachingCredentialsProvider underlyingProvider;

        private AWSCredentialsProviderHolder() {
        }

        public AWSCredentials getCredentials() {
            return this.underlyingProvider.getCredentials();
        }

        public void refresh() {
            this.underlyingProvider.refresh();
        }

        private CognitoCachingCredentialsProvider getUnderlyingProvider() {
            return this.underlyingProvider;
        }

        private void setUnderlyingProvider(CognitoCachingCredentialsProvider underlyingProvider) {
            this.underlyingProvider = underlyingProvider;
        }
    }
}

