/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.core.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.SparseArray;
import android.view.View;
import com.amazonaws.mobile.auth.core.IdentityManager;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.SignInResultHandler;
import com.amazonaws.mobile.auth.core.internal.util.ThreadUtils;
import com.amazonaws.mobile.auth.core.signin.SignInPermissionsHandler;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import java.util.HashMap;
import java.util.Map;

public class SignInManager {
    private static final String LOG_TAG = SignInManager.class.getSimpleName();
    private final Map<Class<? extends SignInProvider>, SignInProvider> signInProviders = new HashMap<Class<? extends SignInProvider>, SignInProvider>();
    private static volatile SignInManager singleton = null;
    private volatile SignInResultHandler signInResultHandler;
    private final SparseArray<SignInPermissionsHandler> providersHandlingPermissions = new SparseArray();
    private SignInProviderResultAdapter resultsAdapter;

    private SignInManager(Context context) {
        if (singleton != null) {
            throw new AssertionError();
        }
        for (Class<? extends SignInProvider> providerClass : IdentityManager.getDefaultIdentityManager().getSignInProviderClasses()) {
            SignInProvider provider;
            try {
                provider = providerClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            provider.initialize(context, IdentityManager.getDefaultIdentityManager().getConfiguration());
            this.signInProviders.put(providerClass, provider);
            if (!(provider instanceof SignInPermissionsHandler)) continue;
            SignInPermissionsHandler handler = (SignInPermissionsHandler)((Object)provider);
            this.providersHandlingPermissions.put(handler.getPermissionRequestCode(), (Object)handler);
        }
        singleton = this;
    }

    public static synchronized SignInManager getInstance() {
        return singleton;
    }

    public static synchronized SignInManager getInstance(Context context) {
        if (singleton == null) {
            singleton = new SignInManager(context);
        }
        return singleton;
    }

    public void setResultHandler(SignInResultHandler signInResultHandler) {
        this.signInResultHandler = signInResultHandler;
    }

    public SignInResultHandler getResultHandler() {
        return this.signInResultHandler;
    }

    public static synchronized void dispose() {
        singleton = null;
    }

    public SignInProvider getPreviouslySignedInProvider() {
        for (SignInProvider provider : this.signInProviders.values()) {
            if (!provider.refreshUserSignInState()) continue;
            return provider;
        }
        return null;
    }

    public void refreshCredentialsWithProvider(Activity activity, IdentityProvider provider, SignInProviderResultHandler resultsHandler) {
        if (provider == null) {
            throw new IllegalArgumentException("The sign-in provider cannot be null.");
        }
        if (provider.getToken() == null) {
            resultsHandler.onError(provider, new IllegalArgumentException("Given provider not previously logged in."));
        }
        this.resultsAdapter = new SignInProviderResultAdapter(activity, resultsHandler);
        IdentityManager.getDefaultIdentityManager().setProviderResultsHandler(this.resultsAdapter);
        IdentityManager.getDefaultIdentityManager().federateWithProvider(provider);
    }

    public void setProviderResultsHandler(Activity activity, SignInProviderResultHandler resultsHandler) {
        this.resultsAdapter = new SignInProviderResultAdapter(activity, resultsHandler);
        IdentityManager.getDefaultIdentityManager().setProviderResultsHandler(this.resultsAdapter);
    }

    public View.OnClickListener initializeSignInButton(Class<? extends SignInProvider> providerClass, View buttonView) {
        SignInProvider provider = this.findProvider(providerClass);
        return provider.initializeSignInButton(this.resultsAdapter.getActivity(), buttonView, IdentityManager.getDefaultIdentityManager().getResultsAdapter());
    }

    private SignInProvider findProvider(Class<? extends SignInProvider> providerClass) {
        SignInProvider provider = this.signInProviders.get(providerClass);
        if (provider == null) {
            throw new IllegalArgumentException("No such provider : " + providerClass.getName());
        }
        return provider;
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        for (SignInProvider provider : this.signInProviders.values()) {
            if (!provider.isRequestCodeOurs(requestCode)) continue;
            provider.handleActivityResult(requestCode, resultCode, data);
            return true;
        }
        return false;
    }

    public void handleRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        SignInPermissionsHandler handler = (SignInPermissionsHandler)this.providersHandlingPermissions.get(requestCode);
        if (handler != null) {
            handler.handleRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private class SignInProviderResultAdapter
    implements SignInProviderResultHandler {
        private final SignInProviderResultHandler handler;
        private final Activity activity;

        private SignInProviderResultAdapter(Activity activity, SignInProviderResultHandler handler) {
            this.handler = handler;
            this.activity = activity;
        }

        private Activity getActivity() {
            return this.activity;
        }

        @Override
        public void onSuccess(final IdentityProvider provider) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SignInProviderResultAdapter.this.handler.onSuccess(provider);
                }
            });
        }

        @Override
        public void onCancel(final IdentityProvider provider) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SignInProviderResultAdapter.this.handler.onCancel(provider);
                }
            });
        }

        @Override
        public void onError(final IdentityProvider provider, final Exception ex) {
            ThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SignInProviderResultAdapter.this.handler.onError(provider, ex);
                }
            });
        }
    }
}

