/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.gradle.ApolloExtension;
import com.google.common.base.Joiner;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class ApolloClassGenTask
extends SourceTask {
    static final String NAME = "generate%sApolloClasses";
    @Internal
    private String variant;
    @Internal
    private ApolloExtension apolloExtension;
    @OutputDirectory
    private File outputDir;
    private NullableValueType nullableValueType;

    public void init(String variant, ApolloExtension apolloExtension) {
        this.variant = variant;
        this.apolloExtension = apolloExtension;
        this.nullableValueType = apolloExtension.getNullableValueType() == null ? NullableValueType.ANNOTATED : NullableValueType.Companion.findByValue(apolloExtension.getNullableValueType());
        this.outputDir = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.Companion.getOUTPUT_DIRECTORY()));
    }

    @TaskAction
    void generateClasses(IncrementalTaskInputs inputs) {
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                File inputFile = inputFileDetails.getFile();
                if (!inputFile.isFile()) {
                    return;
                }
                GraphQLCompiler.Arguments args = new GraphQLCompiler.Arguments(inputFile, ApolloClassGenTask.this.outputDir, ApolloClassGenTask.this.apolloExtension.getCustomTypeMapping(), ApolloClassGenTask.this.nullableValueType, ApolloClassGenTask.this.apolloExtension.isGenerateAccessors(), ApolloClassGenTask.this.apolloExtension.isUseSemanticNaming(), ApolloClassGenTask.this.apolloExtension.isGenerateModelBuilder(), ApolloClassGenTask.this.apolloExtension.getOutputPackageName());
                new GraphQLCompiler().write(args);
            }
        });
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public NullableValueType getNullableValueType() {
        return this.nullableValueType;
    }

    public void setNullableValueType(NullableValueType nullableValueType) {
        this.nullableValueType = nullableValueType;
    }

    public ApolloExtension getApolloExtension() {
        return this.apolloExtension;
    }

    public void setApolloExtension(ApolloExtension apolloExtension) {
        this.apolloExtension = apolloExtension;
    }
}

