/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.InputFieldSpec;
import com.apollographql.apollo.compiler.InputFieldSpec$WhenMappings;
import com.apollographql.apollo.compiler.JavaTypeResolver;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.UtilKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0002!\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec;", "", "type", "Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "name", "", "graphQLType", "javaType", "Lcom/squareup/javapoet/TypeName;", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;Ljava/lang/String;Ljava/lang/String;Lcom/squareup/javapoet/TypeName;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getGraphQLType", "()Ljava/lang/String;", "getJavaType", "()Lcom/squareup/javapoet/TypeName;", "getName", "normalizedName", "getType", "()Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "writeCustomCode", "Lcom/squareup/javapoet/CodeBlock;", "writerParam", "writeCustomList", "writeEnumCode", "writeObjectCode", "marshaller", "writeObjectList", "writeScalarCode", "writeScalarList", "writeValueCode", "Companion", "Type", "aws-android-sdk-appsync-compiler"})
public final class InputFieldSpec {
    private final String normalizedName;
    @NotNull
    private final Type type;
    @NotNull
    private final String name;
    @NotNull
    private final String graphQLType;
    @NotNull
    private final TypeName javaType;
    @NotNull
    private final CodeGenerationContext context;
    private static final Map<Type, String> WRITE_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec LIST_ITEM_WRITER_PARAM;
    public static final Companion Companion;

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock marshaller) {
        CodeBlock codeBlock;
        CodeBlock codeBlock2;
        CodeBlock codeBlock3;
        Intrinsics.checkParameterIsNotNull((Object)writerParam, (String)"writerParam");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        switch (InputFieldSpec$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock3 = this.writeScalarCode(writerParam);
                break;
            }
            case 6: {
                codeBlock3 = this.writeEnumCode(writerParam);
                break;
            }
            case 7: {
                codeBlock3 = this.writeCustomCode(writerParam);
                break;
            }
            case 8: {
                codeBlock3 = this.writeObjectCode(writerParam, marshaller);
                break;
            }
            case 9: {
                codeBlock3 = this.writeScalarList(writerParam);
                break;
            }
            case 10: {
                codeBlock3 = this.writeCustomList(writerParam);
                break;
            }
            case 11: {
                codeBlock3 = this.writeObjectList(writerParam, marshaller);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CodeBlock it = codeBlock2 = codeBlock3;
        if (UtilKt.isOptional(this.javaType)) {
            CodeBlock codeBlock4 = CodeBlock.builder().beginControlFlow("if ($L.defined)", new Object[]{this.normalizedName}).add(it).endControlFlow().build();
            codeBlock = codeBlock4;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock4, (String)"CodeBlock.builder()\n    \u2026ow()\n            .build()");
        } else {
            codeBlock = it;
        }
        return codeBlock;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam) {
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam) {
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = UtilKt.normalizeGraphQlType(this.graphQLType);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string3;
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L.$L, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, customScalarEnum, customScalarEnumConst, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026alarEnumConst, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, (Function1)new Function1<CodeBlock, CodeBlock>(marshaller){
            final /* synthetic */ CodeBlock $marshaller;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])new Object[]{it, this.$marshaller});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
            {
                this.$marshaller = codeBlock;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeScalarList(CodeBlock writerParam) {
        TypeName typeName = UtilKt.unwrapOptionalType(this.javaType, true);
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        String string = SCALAR_LIST_ITEM_WRITE_METHODS.get(rawFieldType);
        if (string == null) {
            string = "writeString";
        }
        String writeMethod = string;
        CodeBlock writeStatement = CodeBlock.builder().beginControlFlow("for ($T $L : $L)", new Object[]{rawFieldType, "$item", UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null)}).add(UtilKt.isEnum(rawFieldType, this.context) ? CodeBlock.of((String)"$L.$L($L.name());\n", (Object[])new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, writeMethod, "$item"}) : CodeBlock.of((String)"$L.$L($L);\n", (Object[])new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, writeMethod, "$item"})).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((java.lang.reflect.Type)((Object)InputFieldWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addException((java.lang.reflect.Type)((Object)IOException.class)).addParameter(LIST_ITEM_WRITER_PARAM).addCode(writeStatement).build()).build();
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomList(CodeBlock writerParam) {
        TypeName typeName = UtilKt.unwrapOptionalType(this.javaType, true);
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String $i$a$1$with = UtilKt.normalizeGraphQlType(this.graphQLType);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string = $i$a$1$with;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string2;
        CodeBlock writeStatement = CodeBlock.builder().beginControlFlow("for ($T $L : $L)", new Object[]{rawFieldType, "$item", UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null)}).addStatement("$L.writeCustom($T.$L, $L)", new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, customScalarEnum, customScalarEnumConst, "$item"}).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((java.lang.reflect.Type)((Object)InputFieldWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(LIST_ITEM_WRITER_PARAM).addException((java.lang.reflect.Type)((Object)IOException.class)).addCode(writeStatement).build()).build();
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectList(CodeBlock writerParam, CodeBlock marshaller) {
        TypeName typeName = UtilKt.unwrapOptionalType(this.javaType, true);
        TypeName $receiver = typeName;
        TypeName rawFieldType = UtilKt.isList($receiver) ? UtilKt.listParamType($receiver) : $receiver;
        CodeBlock writeStatement = CodeBlock.builder().beginControlFlow("for ($T $L : $L)", new Object[]{rawFieldType, "$item", UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null)}).addStatement("$L.writeObject($L.$L)", new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, "$item", marshaller}).endControlFlow().build();
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((java.lang.reflect.Type)((Object)InputFieldWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(LIST_ITEM_WRITER_PARAM).addException((java.lang.reflect.Type)((Object)IOException.class)).addCode(writeStatement).build()).build();
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, (Function1)new Function1<CodeBlock, CodeBlock>(listWriterType){
            final /* synthetic */ TypeSpec $listWriterType;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{this.$listWriterType});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L\", listWriterType)");
                return codeBlock;
            }
            {
                this.$listWriterType = typeSpec;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026S[type], name, valueCode)");
        return codeBlock;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getGraphQLType() {
        return this.graphQLType;
    }

    @NotNull
    public final TypeName getJavaType() {
        return this.javaType;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    public InputFieldSpec(@NotNull Type type, @NotNull String name, @NotNull String graphQLType, @NotNull TypeName javaType, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
        Intrinsics.checkParameterIsNotNull((Object)javaType, (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.type = type;
        this.name = name;
        this.graphQLType = graphQLType;
        this.javaType = javaType;
        this.context = context;
        this.normalizedName = UtilKt.escapeJavaReservedWord(StringsKt.decapitalize((String)this.name));
    }

    static {
        Companion = new Companion(null);
        WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)Type.STRING), (Object)"writeString"), TuplesKt.to((Object)((Object)Type.INT), (Object)"writeInt"), TuplesKt.to((Object)((Object)Type.LONG), (Object)"writeLong"), TuplesKt.to((Object)((Object)Type.DOUBLE), (Object)"writeDouble"), TuplesKt.to((Object)((Object)Type.BOOLEAN), (Object)"writeBoolean"), TuplesKt.to((Object)((Object)Type.ENUM), (Object)"writeString"), TuplesKt.to((Object)((Object)Type.CUSTOM), (Object)"writeCustom"), TuplesKt.to((Object)((Object)Type.OBJECT), (Object)"writeObject"), TuplesKt.to((Object)((Object)Type.SCALAR_LIST), (Object)"writeList"), TuplesKt.to((Object)((Object)Type.CUSTOM_LIST), (Object)"writeList"), TuplesKt.to((Object)((Object)Type.OBJECT_LIST), (Object)"writeList")});
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"writeString"), TuplesKt.to((Object)TypeName.INT, (Object)"writeInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"writeInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"writeLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"writeLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"writeDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"writeBoolean")});
        LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((java.lang.reflect.Type)((java.lang.reflect.Type)((Object)InputFieldWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "", "(Ljava/lang/String;I)V", "STRING", "INT", "LONG", "DOUBLE", "BOOLEAN", "ENUM", "OBJECT", "SCALAR_LIST", "CUSTOM_LIST", "OBJECT_LIST", "CUSTOM", "aws-android-sdk-appsync-compiler"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STRING;
        public static final /* enum */ Type INT;
        public static final /* enum */ Type LONG;
        public static final /* enum */ Type DOUBLE;
        public static final /* enum */ Type BOOLEAN;
        public static final /* enum */ Type ENUM;
        public static final /* enum */ Type OBJECT;
        public static final /* enum */ Type SCALAR_LIST;
        public static final /* enum */ Type CUSTOM_LIST;
        public static final /* enum */ Type OBJECT_LIST;
        public static final /* enum */ Type CUSTOM;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[11];
            Type[] typeArray2 = typeArray;
            typeArray[0] = STRING = new Type();
            typeArray[1] = INT = new Type();
            typeArray[2] = LONG = new Type();
            typeArray[3] = DOUBLE = new Type();
            typeArray[4] = BOOLEAN = new Type();
            typeArray[5] = ENUM = new Type();
            typeArray[6] = OBJECT = new Type();
            typeArray[7] = SCALAR_LIST = new Type();
            typeArray[8] = CUSTOM_LIST = new Type();
            typeArray[9] = OBJECT_LIST = new Type();
            typeArray[10] = CUSTOM = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec$Companion;", "", "()V", "LIST_ITEM_WRITER_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "kotlin.jvm.PlatformType", "SCALAR_LIST_ITEM_WRITE_METHODS", "", "Lcom/squareup/javapoet/TypeName;", "", "WRITE_METHODS", "Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "build", "Lcom/apollographql/apollo/compiler/InputFieldSpec;", "name", "graphQLType", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "nullableValueType", "Lcom/apollographql/apollo/compiler/NullableValueType;", "aws-android-sdk-appsync-compiler"})
    public static final class Companion {
        @NotNull
        public final InputFieldSpec build(@NotNull String name, @NotNull String graphQLType, @NotNull CodeGenerationContext context, @NotNull NullableValueType nullableValueType) {
            Type type;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            TypeName javaType = JavaTypeResolver.resolve$default(new JavaTypeResolver(context, "", false, 4, null), graphQLType, false, nullableValueType, 2, null);
            TypeName normalizedJavaType = UtilKt.unwrapOptionalType(javaType, true);
            if (UtilKt.isList(normalizedJavaType)) {
                TypeName rawFieldType;
                TypeName typeName = normalizedJavaType;
                TypeName it = typeName;
                TypeName typeName2 = rawFieldType = UtilKt.isList(it) ? UtilKt.listParamType(it) : it;
                type = UtilKt.isCustomScalarType(graphQLType, context) ? Type.CUSTOM_LIST : (UtilKt.isScalar(rawFieldType, context) ? Type.SCALAR_LIST : Type.OBJECT_LIST);
            } else {
                TypeName typeName;
                type = UtilKt.isScalar(normalizedJavaType, context) ? (Intrinsics.areEqual((Object)(typeName = normalizedJavaType), (Object)TypeName.INT) || Intrinsics.areEqual((Object)typeName, (Object)TypeName.INT.box()) ? Type.INT : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.LONG) || Intrinsics.areEqual((Object)typeName, (Object)TypeName.LONG.box()) ? Type.LONG : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.DOUBLE) || Intrinsics.areEqual((Object)typeName, (Object)TypeName.DOUBLE.box()) ? Type.DOUBLE : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.BOOLEAN) || Intrinsics.areEqual((Object)typeName, (Object)TypeName.BOOLEAN.box()) ? Type.BOOLEAN : (UtilKt.isEnum(normalizedJavaType, context) ? Type.ENUM : Type.STRING))))) : (UtilKt.isCustomScalarType(graphQLType, context) ? Type.CUSTOM : Type.OBJECT);
            }
            Type type2 = type;
            return new InputFieldSpec(type2, name, graphQLType, javaType, context);
        }

        @NotNull
        public static /* synthetic */ InputFieldSpec build$default(Companion companion, String string, String string2, CodeGenerationContext codeGenerationContext, NullableValueType nullableValueType, int n, Object object) {
            if ((n & 8) != 0) {
                nullableValueType = NullableValueType.INPUT_TYPE;
            }
            return companion.build(string, string2, codeGenerationContext, nullableValueType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

