/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.apigateway;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.mobileconnectors.apigateway.ApiResponse;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class ApiRequest {
    private final Request<ApiResponse> request;

    public ApiRequest(String serviceName) {
        this.request = new DefaultRequest(serviceName);
    }

    public ApiRequest() {
        this.request = new DefaultRequest("");
    }

    public ApiRequest withHeaders(Map<String, String> headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public ApiRequest addHeader(String header, String value) {
        this.request.addHeader(header, value);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.request.getHeaders();
    }

    public ApiRequest withPath(String path) {
        this.request.setResourcePath(path);
        return this;
    }

    public String getPath() {
        return this.request.getResourcePath();
    }

    public ApiRequest withParameters(Map<String, String> parameters) {
        this.request.setParameters(parameters);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.request.getParameters();
    }

    public ApiRequest withParameter(String name, String value) {
        this.request.addParameter(name, value);
        return this;
    }

    public ApiRequest withHttpMethod(HttpMethodName httpMethod) {
        this.request.setHttpMethod(httpMethod);
        return this;
    }

    public HttpMethodName getHttpMethod() {
        return this.request.getHttpMethod();
    }

    public ApiRequest withBody(InputStream body) {
        this.request.setContent(body);
        return this;
    }

    public ApiRequest withBody(byte[] body) {
        this.request.setContent((InputStream)new ByteArrayInputStream(body));
        return this;
    }

    public ApiRequest withBody(String body) {
        byte[] contentBytes = body.getBytes(StringUtils.UTF8);
        this.request.setContent((InputStream)new ByteArrayInputStream(contentBytes));
        return this;
    }

    Request<ApiResponse> getRequest() {
        return this.request;
    }
}

