/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.apigateway;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.mobileconnectors.apigateway.ApiClientHandler;
import com.amazonaws.mobileconnectors.apigateway.annotation.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ApiClientFactory {
    private static final String AMAZON_API_GATEWAY_SERVICE_NAME = "execute-api";
    private static final String AMAZON_API_GATEWAY_REGION = "us-east-1";
    private String endpoint;
    private String apiKey;
    private AWSCredentialsProvider provider;

    public ApiClientFactory endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ApiClientFactory apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ApiClientFactory credentialsProvider(AWSCredentialsProvider provider) {
        this.provider = provider;
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        String endpoint = this.getEndpoint(apiClass);
        String apiName = this.getApiName(apiClass);
        ApiClientHandler handler = this.getHandler(endpoint, apiName);
        Object proxy = Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)handler);
        return apiClass.cast(proxy);
    }

    ApiClientHandler getHandler(String endpoint, String apiName) {
        Signer signer = this.getSigner();
        ApiClientHandler handler = new ApiClientHandler(endpoint, apiName, signer, this.provider, this.apiKey);
        return handler;
    }

    String getEndpoint(Class<?> apiClass) {
        Service service = apiClass.getAnnotation(Service.class);
        if (service == null) {
            throw new IllegalArgumentException("Can't find annotation Service");
        }
        return this.endpoint == null ? service.endpoint() : this.endpoint;
    }

    String getApiName(Class<?> apiClass) {
        return apiClass.getSimpleName();
    }

    Signer getSigner() {
        AWS4Signer signer = new AWS4Signer();
        signer.setServiceName(AMAZON_API_GATEWAY_SERVICE_NAME);
        signer.setRegionName(AMAZON_API_GATEWAY_REGION);
        return signer;
    }
}

