/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.AutoAcknowledger;
import com.amazon.sqs.javamessaging.acknowledge.RangedAcknowledger;
import com.amazon.sqs.javamessaging.acknowledge.UnorderedAcknowledger;

public enum AcknowledgeMode {
    ACK_AUTO,
    ACK_UNORDERED,
    ACK_RANGE;

    private int originalAcknowledgeMode;

    public AcknowledgeMode withOriginalAcknowledgeMode(int originalAcknowledgeMode) {
        this.originalAcknowledgeMode = originalAcknowledgeMode;
        return this;
    }

    public int getOriginalAcknowledgeMode() {
        return this.originalAcknowledgeMode;
    }

    public Acknowledger createAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient, SQSSession parentSQSSession) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ACK_AUTO -> new AutoAcknowledger(amazonSQSClient, parentSQSSession);
            case ACK_RANGE -> new RangedAcknowledger(amazonSQSClient, parentSQSSession);
            case ACK_UNORDERED -> new UnorderedAcknowledger(amazonSQSClient, parentSQSSession);
        };
    }
}

