/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSMessageConsumerPrefetch;
import com.amazon.sqs.javamessaging.acknowledge.BulkSQSOperation;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;

public class NegativeAcknowledger
extends BulkSQSOperation {
    private static final int NACK_TIMEOUT = 0;
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;

    public NegativeAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient) {
        this.amazonSQSClient = amazonSQSClient;
    }

    public void bulkAction(ArrayDeque<SQSMessageConsumerPrefetch.MessageManager> messageQueue, String queueUrl) throws JMSException {
        ArrayList<String> receiptHandles = new ArrayList<String>();
        while (!messageQueue.isEmpty()) {
            receiptHandles.add(((SQSMessage)messageQueue.pollFirst().getMessage()).getReceiptHandle());
            if (receiptHandles.size() != 10) continue;
            this.action(queueUrl, receiptHandles);
            receiptHandles.clear();
        }
        this.action(queueUrl, receiptHandles);
    }

    @Override
    public void action(String queueUrl, List<String> receiptHandles) throws JMSException {
        if (receiptHandles == null || receiptHandles.isEmpty()) {
            return;
        }
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> nackEntries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(receiptHandles.size());
        int batchId = 0;
        for (String messageReceiptHandle : receiptHandles) {
            ChangeMessageVisibilityBatchRequestEntry changeMessageVisibilityBatchRequestEntry = (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(Integer.toString(batchId)).receiptHandle(messageReceiptHandle).visibilityTimeout(Integer.valueOf(0)).build();
            nackEntries.add(changeMessageVisibilityBatchRequestEntry);
            ++batchId;
        }
        this.amazonSQSClient.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)ChangeMessageVisibilityBatchRequest.builder().queueUrl(queueUrl).entries(nackEntries).build());
    }
}

